/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service;

import static org.mule.runtime.api.scheduler.SchedulerConfig.config;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.ws.WebSocketBroadcaster;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.HttpClientConnectionManager;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;

import com.mulesoft.service.http.impl.service.client.EEHttpClientConnectionManager;
import com.mulesoft.service.http.impl.service.server.EEHttpListenerConnectionManager;
import com.mulesoft.service.http.impl.service.ws.GrizzlyWebSocketBroadcaster;

/**
 * Implementation of {@link HttpService} that uses Grizzly to create {@link HttpServer}s and its Async HTTP Client provider to
 * create {@link org.mule.runtime.http.api.client.HttpClient}s, including a {@link HostNameResolver} to resolve host names.
 *
 * @since 1.0
 */
public class EEHttpServiceImplementation extends HttpServiceImplementation {

  public EEHttpServiceImplementation(SchedulerService schedulerService) {
    super(schedulerService);
  }

  @Override
  protected HttpClientConnectionManager createClientConnectionManager() {
    return new EEHttpClientConnectionManager(schedulerService);
  }

  protected HttpListenerConnectionManager createListenerConnectionManager(SchedulerService schedulerService) {
    return new EEHttpListenerConnectionManager(schedulerService, config());
  }

  @Override
  public WebSocketBroadcaster newWebSocketBroadcaster() {
    return new GrizzlyWebSocketBroadcaster();
  }

  @Override
  public String getName() {
    return "HTTP EE Service";
  }
}
