/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.ws;

import java.io.IOException;
import java.io.PipedInputStream;

/**
 * A {@link PipedInputStream} that is aware about its status
 *
 * @since 1.3.0
 */
public class ManagedPipedInputStream extends PipedInputStream {

  private boolean open = true;

  @Override
  public void close() throws IOException {
    if (open) {
      open = false;
      super.close();
    }
  }

  public boolean isOpen() {
    return open;
  }
}
