/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.ws;

import java.util.function.Consumer;

/**
 * A {@link FragmentHandlerProvider} which returns instances of {@link PipedFragmentHandler}.
 * <p>
 * A new instance will be invoked the first time that {@link #getFragmentHandler(Consumer)} is invoked. The same instance
 * will be returned until the returned handler is closed or aborted. Only then will it return a new instance and the cycle
 * starts all over again.
 *
 * @since 1.3.0
 */
public class PipedFragmentHandlerProvider implements FragmentHandlerProvider {

  private final String socketId;
  private FragmentHandler fragmentHandler = null;

  public PipedFragmentHandlerProvider(String socketId) {
    this.socketId = socketId;
  }

  @Override
  public FragmentHandler getFragmentHandler(Consumer<FragmentHandler> newFragmentHandlerCallback) {
    synchronized (this) {
      if (fragmentHandler == null) {
        fragmentHandler = new PipedFragmentHandler(socketId, this::recycle);
        newFragmentHandlerCallback.accept(fragmentHandler);
      }

      return fragmentHandler;
    }
  }

  private void recycle() {
    synchronized (this) {
      fragmentHandler = null;
    }
  }
}
