/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.DefaultWebSocketMessage;
import com.mulesoft.service.http.impl.service.client.ws.GrizzlyInboundWebSocketRequest;
import com.mulesoft.service.http.impl.service.client.ws.InboundWebSocket;
import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.server.ws.WebSocketConnectionRejectedException;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.runtime.http.api.server.ws.WebSocketMessage;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyWebSocketHandlerManager
extends WebSocketApplication
implements WebSocketHandlerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyWebSocketHandlerManager.class);
    private final WebSocketHandler handler;
    private boolean stopped = true;
    private RequestMatcherRegistry.RequestMatcherRegistryEntry matcherEntry;

    public GrizzlyWebSocketHandlerManager(WebSocketHandler handler) {
        this.handler = handler;
    }

    public void start() {
        WebSocketEngine.getEngine().register("", this.handler.getPath(), (WebSocketApplication)this);
        this.stopped = false;
        if (this.matcherEntry != null) {
            this.matcherEntry.enable();
        }
    }

    public void stop() {
        this.stopped = true;
        try {
            WebSocketEngine.getEngine().unregister((WebSocketApplication)this);
        }
        finally {
            if (this.matcherEntry != null) {
                this.matcherEntry.disable();
            }
            this.sockets.keySet().forEach(s -> {
                InboundWebSocket socket = (InboundWebSocket)((Object)s);
                socket.close(WebSocketCloseCode.ENDPOINT_GOING_DOWN, "Endpoint stopped").whenComplete((v, e) -> {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(String.format("Failed to close socket '%s' while stopping its endpoint: %s", socket.getId(), e.getMessage()), e);
                    }
                });
            });
        }
    }

    public void dispose() {
        if (this.matcherEntry != null) {
            this.matcherEntry.remove();
        }
    }

    public org.glassfish.grizzly.websockets.WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        GrizzlyInboundWebSocketRequest request = new GrizzlyInboundWebSocketRequest(requestPacket);
        String id = this.handler.getConnectionHandler().getSocketId((WebSocketRequest)request);
        return new InboundWebSocket(id, this.handler, request, handler, requestPacket, listeners);
    }

    public void onConnect(org.glassfish.grizzly.websockets.WebSocket ws) {
        if (this.stopped) {
            throw new IllegalStateException("Endpoint is stopped");
        }
        super.onConnect(ws);
        InboundWebSocket socket = (InboundWebSocket)ws;
        try {
            socket.getResource().getConnectionHandler().onConnect((WebSocket)socket, socket.getRequest());
        }
        catch (WebSocketConnectionRejectedException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Closing Inbound WebSocket '%s' due to exception thrown by onConnect() handler: %s", socket.getId(), e.getMessage()), (Throwable)e);
            }
            ws.close(1006, e.getMessage());
        }
    }

    public void onClose(org.glassfish.grizzly.websockets.WebSocket ws, DataFrame frame) {
        super.onClose(ws, frame);
        InboundWebSocket socket = (InboundWebSocket)ws;
        ClosingFrame closing = (ClosingFrame)frame;
        ((InboundWebSocket)ws).getResource().getConnectionHandler().onClose((WebSocket)socket, socket.getRequest(), WebSocketCloseCode.fromProtocolCode((int)closing.getCode()), closing.getReason());
    }

    public void onMessage(org.glassfish.grizzly.websockets.WebSocket ws, String text) {
        InboundWebSocket socket = (InboundWebSocket)ws;
        socket.getResource().getMessageHandler().onMessage(this.buildMessage(socket, text));
    }

    public void onMessage(org.glassfish.grizzly.websockets.WebSocket ws, byte[] bytes) {
        InboundWebSocket socket = (InboundWebSocket)ws;
        socket.getResource().getMessageHandler().onMessage(this.buildMessage(socket, bytes));
    }

    public void onFragment(org.glassfish.grizzly.websockets.WebSocket socket, byte[] fragment, boolean last) {
        this.onFragment((InboundWebSocket)socket, fragment, MediaType.BINARY, last);
    }

    public void onFragment(org.glassfish.grizzly.websockets.WebSocket socket, String fragment, boolean last) {
        this.onFragment((InboundWebSocket)socket, fragment.getBytes(), MediaType.TEXT, last);
    }

    private void onFragment(InboundWebSocket socket, byte[] data, MediaType mediaType, boolean last) {
        FragmentHandler handler = socket.getFragmentHandler(h -> socket.getResource().getMessageHandler().onMessage(this.buildMessage(socket, h.getInputStream(), mediaType)));
        try {
            if (!handler.write(data) && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Incoming fragment for socket '{}' was discarded because the stream was already closed");
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error found while streaming data on socket %s: %s. Stream will be closed", socket.getId(), e.getMessage()), (Throwable)e);
            handler.abort();
            return;
        }
        if (last) {
            handler.complete();
        }
    }

    private WebSocketMessage buildMessage(InboundWebSocket socket, String text) {
        return this.buildMessage(socket, new ByteArrayInputStream(text.getBytes()), MediaType.TEXT);
    }

    private WebSocketMessage buildMessage(InboundWebSocket socket, byte[] bytes) {
        return this.buildMessage(socket, new ByteArrayInputStream(bytes), MediaType.BINARY);
    }

    private WebSocketMessage buildMessage(InboundWebSocket socket, InputStream stream, MediaType mediaType) {
        return new DefaultWebSocketMessage(socket, (TypedValue<InputStream>)new TypedValue((Object)stream, DataType.builder().type(InputStream.class).mediaType(this.resolveMediaType(socket.getRequest(), mediaType)).build()), socket.getRequest());
    }

    private MediaType resolveMediaType(WebSocketRequest request, MediaType defaultMediaType) {
        MediaType resolved = request.getContentType();
        if (resolved == MediaType.ANY) {
            resolved = defaultMediaType;
        }
        return resolved;
    }

    public void setMatcherEntry(RequestMatcherRegistry.RequestMatcherRegistryEntry matcherEntry) {
        this.matcherEntry = matcherEntry;
    }
}

