/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.ws.DataFrameEmitter;
import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import com.mulesoft.service.http.impl.service.ws.FragmentHandlerProvider;
import com.mulesoft.service.http.impl.service.ws.PipedFragmentHandlerProvider;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;

public class OutboundWebSocket
implements WebSocket {
    private final String id;
    private final URI uri;
    private final WebSocketProtocol protocol;
    private final Set<String> groups = new HashSet<String>();
    private final GrizzlyWebSocketAdapter delegate;
    private final FragmentHandlerProvider fragmentHandlerProvider;

    public OutboundWebSocket(String id, URI uri, WebSocketProtocol protocol, GrizzlyWebSocketAdapter delegate) {
        this.id = id;
        this.uri = uri;
        this.delegate = delegate;
        this.protocol = protocol;
        this.fragmentHandlerProvider = new PipedFragmentHandlerProvider(id);
    }

    public CompletableFuture<Void> send(InputStream content, MediaType mediaType) {
        DataFrameEmitter emitter = MediaTypeUtils.isStringRepresentable((MediaType)mediaType) ? this.textEmitter() : this.binaryEmitter();
        return WebSocketUtils.streamInDataFrames(content, emitter);
    }

    public FragmentHandler getFragmentHandler(Consumer<FragmentHandler> newFragmentHandlerCallback) {
        return this.fragmentHandlerProvider.getFragmentHandler(newFragmentHandlerCallback);
    }

    private DataFrameEmitter textEmitter() {
        return new DataFrameEmitter(){

            @Override
            public CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last) {
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableStream(new String(bytes, offset, len), last));
            }

            @Override
            public CompletableFuture<Void> send(byte[] bytes, int offset, int len) {
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableSend(new String(bytes, offset, len)));
            }
        };
    }

    private DataFrameEmitter binaryEmitter() {
        return new DataFrameEmitter(){

            @Override
            public CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last) {
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableStream(bytes, offset, len, last));
            }

            @Override
            public CompletableFuture<Void> send(byte[] bytes, int offset, int len) {
                if (offset != 0 || len != bytes.length) {
                    byte[] aux = new byte[len];
                    System.arraycopy(bytes, offset, aux, 0, len);
                    bytes = aux;
                }
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableSend(bytes));
            }
        };
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroups() {
        Set<String> set = this.groups;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<String>(this.groups));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String group) {
        Set<String> set = this.groups;
        synchronized (set) {
            this.groups.add(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String group) {
        Set<String> set = this.groups;
        synchronized (set) {
            this.groups.remove(group);
        }
    }

    public CompletableFuture<Void> close(WebSocketCloseCode code, String reason) {
        return WebSocketUtils.asVoid(this.delegate.close(code.getProtocolCode(), reason));
    }

    public WebSocket.WebSocketType getType() {
        return WebSocket.WebSocketType.OUTBOUND;
    }

    public WebSocketProtocol getProtocol() {
        return this.protocol;
    }

    public URI getUri() {
        return this.uri;
    }

    public org.glassfish.grizzly.websockets.WebSocket getGrizzlyWebSocket() {
        return this.delegate.getGrizzlyWebSocket();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OutboundWebSocket) {
            return this.id.equals(((OutboundWebSocket)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "WebSocket Id: " + this.id + "\nType: " + WebSocket.WebSocketType.OUTBOUND + "\nURI: " + this.getUri();
    }
}

