/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.client.builder;

import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.service.http.impl.service.HostNameResolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

/**
 * Handles the replacement of the address in the request url with a resolved ip address.
 */
public class DirectNameResolvingRequestBuilder extends NameResolvingRequestBuilder {

  public DirectNameResolvingRequestBuilder(HttpRequest request, HostNameResolver hostNameResolver) {
    super(request, hostNameResolver);
  }

  @Override
  protected List<InetAddress> getAddresses() throws UnknownHostException {
    return getDomainNameResolver().getAddresses(getHost());
  }

  @Override
  protected List<InetAddress> getRotateAddresses() throws UnknownHostException {
    return getDomainNameResolver().getRotatedAddresses(getHost());
  }
}
