/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.server.ws.WebSocketMessage;

import java.io.InputStream;

/**
 * Default implementation of {@link WebSocketMessage}
 *
 * @since 1.3.0
 */
public class DefaultWebSocketMessage implements WebSocketMessage {

  private final WebSocket socket;
  private final TypedValue<InputStream> content;
  private final WebSocketRequest request;

  public DefaultWebSocketMessage(WebSocket socket, TypedValue<InputStream> content, WebSocketRequest request) {
    this.socket = socket;
    this.content = content;
    this.request = request;
  }

  @Override
  public TypedValue<InputStream> getContent() {
    return content;
  }

  @Override
  public WebSocket getSocket() {
    return socket;
  }

  @Override
  public WebSocketRequest getRequest() {
    return request;
  }
}
