/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import static org.mule.runtime.api.util.Preconditions.checkArgument;
import static org.mule.runtime.http.api.HttpConstants.Method.GET;
import static org.mule.service.http.impl.service.server.grizzly.HttpParser.normalizePathWithSpacesOrEncodedSpaces;
import static org.mule.service.http.impl.util.HttpUtils.SLASH;
import static org.mule.service.http.impl.util.HttpUtils.WILDCARD_CHARACTER;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.util.DefaultRequestMatcherRegistry;

/**
 * Tracks the {@link WebSocketHandlerManager} that is associated to each path
 *
 * @since 1.3.0
 */
public class WebSocketHandlerRegistry {

  private final RequestMatcherRegistry<WebSocketHandlerManager> registry = new DefaultRequestMatcherRegistry<>();

  public WebSocketHandlerManager addHandler(WebSocketHandler handler) {
    String path = normalizePathWithSpacesOrEncodedSpaces(handler.getPath());
    checkArgument(path.startsWith(SLASH) || path.equals(WILDCARD_CHARACTER), "path parameter must start with /");

    final GrizzlyWebSocketHandlerManager handlerManager = new GrizzlyWebSocketHandlerManager(handler);
    handlerManager.setMatcherEntry(registry.add(pathMatcher(path), handlerManager));

    return handlerManager;
  }

  private PathAndMethodRequestMatcher pathMatcher(String path) {
    return PathAndMethodRequestMatcher.builder()
        .path(path)
        .methodRequestMatcher(MethodRequestMatcher.builder().add(GET).build())
        .build();
  }
}
