/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.server;

import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressDelegateFilter;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressFilter;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpServer;

import com.mulesoft.service.http.impl.service.client.ws.WebSocketHandlerRegistry;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.websockets.WebSocketFilter;

/**
 * EE implementation of {@link GrizzlyHttpServer}
 *
 * @since 1.3.0
 */
public class EEGrizzlyHttpServer extends GrizzlyHttpServer {

  private final WebSocketHandlerRegistry handlerRegistry = new WebSocketHandlerRegistry();
  private AtomicBoolean webSocketFilterAdded = new AtomicBoolean(false);
  private GrizzlyAddressDelegateFilter<WebSocketFilter> webSocketFilter;

  public EEGrizzlyHttpServer(ServerAddress serverAddress,
                             TCPNIOTransport transport,
                             HttpListenerRegistry listenerRegistry,
                             Supplier<Scheduler> schedulerSource,
                             Runnable schedulerDisposer,
                             GrizzlyAddressFilter<SSLFilter> sslFilter,
                             GrizzlyAddressDelegateFilter<WebSocketFilter> webSocketFilter,
                             Supplier<Long> shutdownTimeoutSupplier) {
    super(serverAddress, transport, listenerRegistry, schedulerSource, schedulerDisposer, sslFilter, shutdownTimeoutSupplier);
    this.webSocketFilter = webSocketFilter;
  }

  @Override
  public WebSocketHandlerManager addWebSocketHandler(WebSocketHandler handler) {
    if (webSocketFilterAdded.compareAndSet(false, true)) {
      webSocketFilter.addFilterForAddress(getServerAddress(), new WebSocketFilter());
    }

    return handlerRegistry.addHandler(handler);
  }
}
