/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.ws;

import org.mule.api.annotation.NoImplement;

import java.io.IOException;
import java.io.InputStream;

/**
 * Allows to channel the information of a multi fragment Web Socket message into an {@link InputStream}.
 * <p>
 * Clients <b>MUST</b> always invoke either {@link #complete()} or {@link #abort()} once the multi fragment
 * message is over.
 *
 * @since 1.3.0
 */
@NoImplement
public interface FragmentHandler {

  /**
   * Makes the given {@code data} available at the end of the {@link #getInputStream()}
   *
   * @param data a fragment's payload
   * @return {@code true} if the information could be appended to the stream
   * @throws IOException
   */
  boolean write(byte[] data) throws IOException;

  /**
   * @return The stream on which the fragment data is being consolidated
   */
  InputStream getInputStream();

  /**
   * Clients <b>MUST</b> invoke this method once the last fragment of a message has been received.
   */
  void complete();

  /**
   * Clients <b>MUST</b> invoke this method if any exceptional situation will cause the multi fragment message
   * to never complete, meaning that the last fragment will never arrive.
   */
  void abort();
}
