/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws;

import com.mulesoft.service.http.impl.functional.ws.AbstractWebSocketTestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.ws.WebSocketConnectionHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketMessage;
import org.mule.runtime.http.api.server.ws.WebSocketMessageHandler;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.exception.WebSocketClosedException;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;
import org.mule.tck.SimpleUnitTestSupportCustomScheduler;
import org.mule.tck.probe.PollingProber;

public class FullDuplexWebSocketTestCase
extends AbstractWebSocketTestCase {
    private static final String PATH = "/chat";
    private static final String SERVER_CONNECTION_ID = "serverConnection";
    private static final String CLIENT_SOCKET_ID = "clientConnection";
    private static final String SHORT_TEXT_MESSAGE = "Hello There!";
    private static final String SHORT_RESPONSE_MESSAGE = "ACK";
    private static final int PROBE_TIMEOUT = 5000;
    private static final int PROBE_MILLIS = 100;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void fullDuplex() throws Exception {
        this.fullDuplex(PATH, (TypedValue<byte[]>)new TypedValue((Object)SHORT_TEXT_MESSAGE.getBytes(), DataType.TEXT_STRING), (TypedValue<byte[]>)new TypedValue((Object)SHORT_RESPONSE_MESSAGE.getBytes(), DataType.TEXT_STRING));
    }

    @Test
    public void fullDuplexWithStreaming() throws Exception {
        int length = 16438;
        String outboundMessage = RandomStringUtils.randomAlphanumeric((int)16438);
        String responseMessage = RandomStringUtils.randomAlphanumeric((int)16438);
        this.fullDuplex(PATH, (TypedValue<byte[]>)new TypedValue((Object)outboundMessage.getBytes(), DataType.TEXT_STRING), (TypedValue<byte[]>)new TypedValue((Object)responseMessage.getBytes(), DataType.TEXT_STRING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void idleInboundSocketTimeout() throws Exception {
        Latch messageLatch = new Latch();
        final Reference serverSocketConnected = new Reference((Object)false);
        final Reference serverSocketClosed = new Reference((Object)false);
        final Reference serverSocketReference = new Reference();
        WebSocketConnectionHandler connectionHandler = new WebSocketConnectionHandler(){

            public String getSocketId(WebSocketRequest request) {
                return "idle";
            }

            public void onConnect(WebSocket socket, WebSocketRequest request) {
                serverSocketConnected.set((Object)true);
                serverSocketReference.set((Object)socket);
            }

            public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
                serverSocketClosed.set((Object)true);
            }
        };
        Reference messageHolder = new Reference();
        WebSocketMessageHandler messageHandler = message -> {
            messageHolder.set((Object)message);
            messageLatch.release();
        };
        int idleTimeoutMillis = 5000;
        TestWebSocketHandler handler = new TestWebSocketHandler(PATH, connectionHandler, messageHandler, 5000L);
        this.handlerManager = server.addWebSocketHandler((WebSocketHandler)handler);
        this.handlerManager.start();
        TestWebSocketCallback callback = new TestWebSocketCallback();
        this.connect(callback);
        try {
            PollingProber.check((long)1000L, (long)100L, () -> {
                Assert.assertThat((Object)callback.isConnected(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)serverSocketConnected.get(), (Matcher)CoreMatchers.is((Object)true));
                return true;
            });
            PollingProber.check((long)6000L, (long)500L, () -> {
                Assert.assertThat((Object)serverSocketClosed.get(), (Matcher)CoreMatchers.is((Object)false));
                return true;
            });
        }
        finally {
            if (serverSocketReference.get() != null) {
                ((WebSocket)serverSocketReference.get()).close(WebSocketCloseCode.NORMAL_CLOSURE, "").get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remotelyClosedSocketThrowsConnectionException() throws Exception {
        Latch messageLatch = new Latch();
        final Reference serverSocketConnected = new Reference((Object)false);
        final Reference serverSocketClosed = new Reference((Object)false);
        final Reference serverSocketReference = new Reference();
        WebSocketConnectionHandler connectionHandler = new WebSocketConnectionHandler(){

            public String getSocketId(WebSocketRequest request) {
                return "idle";
            }

            public void onConnect(WebSocket socket, WebSocketRequest request) {
                serverSocketConnected.set((Object)true);
                serverSocketReference.set((Object)socket);
            }

            public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
                serverSocketClosed.set((Object)true);
            }
        };
        Reference messageHolder = new Reference();
        WebSocketMessageHandler messageHandler = message -> {
            messageHolder.set((Object)message);
            messageLatch.release();
        };
        int idleTimeoutMillis = 500;
        TestWebSocketHandler handler = new TestWebSocketHandler(PATH, connectionHandler, messageHandler, 500L);
        this.handlerManager = server.addWebSocketHandler((WebSocketHandler)handler);
        this.handlerManager.start();
        TestWebSocketCallback callback = new TestWebSocketCallback();
        WebSocket client = this.connect(callback);
        try {
            PollingProber.check((long)500L, (long)10L, () -> {
                Assert.assertThat((Object)callback.isConnected(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)serverSocketConnected.get(), (Matcher)CoreMatchers.is((Object)true));
                return true;
            });
            PollingProber.check((long)500L, (long)500L, () -> {
                Assert.assertThat((Object)serverSocketClosed.get(), (Matcher)CoreMatchers.is((Object)false));
                return true;
            });
            Thread.sleep(5000L);
            Reference error = new Reference();
            Latch closedLatch = new Latch();
            client.send((InputStream)new ByteArrayInputStream("Hello closed!".getBytes()), MediaType.TEXT).whenComplete((v, e) -> {
                if (e != null) {
                    error.set(e);
                    closedLatch.release();
                }
            });
            closedLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertThat((Object)error.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(WebSocketConnectionException.class)));
        }
        finally {
            if (serverSocketReference.get() != null) {
                ((WebSocket)serverSocketReference.get()).close(WebSocketCloseCode.NORMAL_CLOSURE, "").get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remotelyClosedSocketReconnects() throws Exception {
        Latch messageLatch = new Latch();
        final Reference serverSocketConnected = new Reference((Object)false);
        final Reference serverSocketClosed = new Reference((Object)false);
        final Reference serverSocketReference = new Reference();
        WebSocketConnectionHandler connectionHandler = new WebSocketConnectionHandler(){

            public String getSocketId(WebSocketRequest request) {
                return "idle";
            }

            public void onConnect(WebSocket socket, WebSocketRequest request) {
                serverSocketConnected.set((Object)true);
                serverSocketReference.set((Object)socket);
            }

            public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
                serverSocketClosed.set((Object)true);
            }
        };
        Reference messageHolder = new Reference();
        WebSocketMessageHandler messageHandler = message -> {
            messageHolder.set((Object)message);
            messageLatch.release();
        };
        int idleTimeoutMillis = 500;
        TestWebSocketHandler handler = new TestWebSocketHandler(PATH, connectionHandler, messageHandler, 500L);
        this.handlerManager = server.addWebSocketHandler((WebSocketHandler)handler);
        this.handlerManager.start();
        TestWebSocketCallback callback = new TestWebSocketCallback();
        WebSocket client = this.connect(callback);
        SimpleUnitTestSupportCustomScheduler scheduler = new SimpleUnitTestSupportCustomScheduler(1, Thread::new, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        try {
            PollingProber.check((long)500L, (long)10L, () -> {
                Assert.assertThat((Object)callback.isConnected(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)serverSocketConnected.get(), (Matcher)CoreMatchers.is((Object)true));
                return true;
            });
            PollingProber.check((long)500L, (long)500L, () -> {
                Assert.assertThat((Object)serverSocketClosed.get(), (Matcher)CoreMatchers.is((Object)false));
                return true;
            });
            Thread.sleep(5000L);
            Reference error = new Reference();
            Latch closedLatch = new Latch();
            client.send((InputStream)new ByteArrayInputStream("Hello closed!".getBytes()), MediaType.TEXT).whenComplete((v, e) -> {
                if (e != null) {
                    error.set(e);
                    closedLatch.release();
                }
            });
            closedLatch.await(10L, TimeUnit.SECONDS);
            Assert.assertThat((Object)error.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(WebSocketConnectionException.class)));
            Assert.assertThat((Object)client.supportsReconnection(), (Matcher)CoreMatchers.is((Object)true));
            client = (WebSocket)client.reconnect((RetryPolicyTemplate)new SimpleRetryPolicyTemplate(500L, 2), (Scheduler)scheduler).get();
            Latch reconnectedLatch = new Latch();
            error.set(null);
            String reconnectionMessage = "Hello reconnected!";
            client.send((InputStream)new ByteArrayInputStream(reconnectionMessage.getBytes()), MediaType.TEXT).whenComplete((v, e) -> {
                if (e != null) {
                    error.set(e);
                }
                reconnectedLatch.release();
            });
            try {
                Assert.assertThat((Object)reconnectedLatch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)error.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                PollingProber.check((long)5000L, (long)500L, () -> {
                    WebSocketMessage message = (WebSocketMessage)messageHolder.get();
                    Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                    Assert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)message.getContent().getValue())), (Matcher)CoreMatchers.equalTo((Object)reconnectionMessage));
                    return true;
                });
            }
            finally {
                client.close(WebSocketCloseCode.NORMAL_CLOSURE, "");
            }
        }
        finally {
            scheduler.stop();
            if (serverSocketReference.get() != null) {
                ((WebSocket)serverSocketReference.get()).close(WebSocketCloseCode.NORMAL_CLOSURE, "").get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void alreadyClosedSocket() throws Exception {
        Latch messageLatch = new Latch();
        final Reference serverSocketConnected = new Reference((Object)false);
        final Reference serverSocketClosed = new Reference((Object)false);
        final Reference serverSocketReference = new Reference();
        WebSocketConnectionHandler connectionHandler = new WebSocketConnectionHandler(){

            public String getSocketId(WebSocketRequest request) {
                return "idle";
            }

            public void onConnect(WebSocket socket, WebSocketRequest request) {
                serverSocketConnected.set((Object)true);
                serverSocketReference.set((Object)socket);
            }

            public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
                serverSocketClosed.set((Object)true);
            }
        };
        Reference messageHolder = new Reference();
        WebSocketMessageHandler messageHandler = message -> {
            messageHolder.set((Object)message);
            messageLatch.release();
        };
        int idleTimeoutMillis = 5000;
        TestWebSocketHandler handler = new TestWebSocketHandler(PATH, connectionHandler, messageHandler, 5000L);
        this.handlerManager = server.addWebSocketHandler((WebSocketHandler)handler);
        this.handlerManager.start();
        TestWebSocketCallback callback = new TestWebSocketCallback();
        WebSocket client = this.connect(callback);
        try {
            PollingProber.check((long)1000L, (long)100L, () -> {
                Assert.assertThat((Object)callback.isConnected(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)serverSocketConnected.get(), (Matcher)CoreMatchers.is((Object)true));
                return true;
            });
            client.close(WebSocketCloseCode.NORMAL_CLOSURE, "").get();
            this.expectedException.expect(ExecutionException.class);
            this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(WebSocketClosedException.class)));
            client.send((InputStream)new ByteArrayInputStream("I'm closed!".getBytes()), MediaType.TEXT).get();
        }
        finally {
            if (serverSocketReference.get() != null) {
                ((WebSocket)serverSocketReference.get()).close(WebSocketCloseCode.NORMAL_CLOSURE, "").get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullDuplex(String path, TypedValue<byte[]> outboundMessage, TypedValue<byte[]> responseMessage) throws Exception {
        Latch messageLatch = new Latch();
        final Reference serverSocketConnected = new Reference((Object)false);
        final Reference serverSocketClosed = new Reference((Object)false);
        final Reference serverSocketReference = new Reference();
        WebSocketConnectionHandler connectionHandler = new WebSocketConnectionHandler(){

            public String getSocketId(WebSocketRequest request) {
                return (String)request.getQueryParams().get((Object)"id");
            }

            public void onConnect(WebSocket socket, WebSocketRequest request) {
                serverSocketConnected.set((Object)true);
                serverSocketReference.set((Object)socket);
            }

            public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
                serverSocketClosed.set((Object)true);
            }
        };
        Reference messageHolder = new Reference();
        WebSocketMessageHandler messageHandler = message -> {
            messageHolder.set((Object)message);
            messageLatch.release();
        };
        TestWebSocketHandler handler = new TestWebSocketHandler(path, connectionHandler, messageHandler);
        this.handlerManager = server.addWebSocketHandler((WebSocketHandler)handler);
        this.handlerManager.start();
        TestWebSocketCallback callback = new TestWebSocketCallback();
        WebSocket client = this.connect(callback);
        client.send((InputStream)new ByteArrayInputStream((byte[])outboundMessage.getValue()), outboundMessage.getDataType().getMediaType()).get();
        messageLatch.await();
        WebSocket serverSocket = (WebSocket)serverSocketReference.get();
        try {
            Assert.assertThat((Object)serverSocketConnected.get(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)serverSocket.getUri().getPath(), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)serverSocket.getId(), (Matcher)CoreMatchers.equalTo((Object)SERVER_CONNECTION_ID));
            Assert.assertThat((Object)serverSocket.getType(), (Matcher)CoreMatchers.is((Object)WebSocket.WebSocketType.INBOUND));
            WebSocketMessage message2 = (WebSocketMessage)messageHolder.get();
            Assert.assertThat((Object)message2.getSocket().getId(), (Matcher)CoreMatchers.equalTo((Object)SERVER_CONNECTION_ID));
            Assert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)message2.getContent().getValue())), (Matcher)CoreMatchers.equalTo((Object)new String((byte[])outboundMessage.getValue())));
            Assert.assertThat((Object)callback.isConnected(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)callback.isClosed(), (Matcher)CoreMatchers.is((Object)false));
            serverSocket.send((InputStream)new ByteArrayInputStream((byte[])responseMessage.getValue()), responseMessage.getDataType().getMediaType()).get();
            PollingProber.check((long)5000L, (long)100L, () -> !callback.getMessages().isEmpty());
            Assert.assertThat(callback.getMessages(), (Matcher)Matchers.hasSize((int)1));
            Pair<WebSocket, TypedValue<InputStream>> response = callback.getMessages().get(0);
            Assert.assertThat((Object)((WebSocket)response.getFirst()).getId(), (Matcher)CoreMatchers.equalTo((Object)CLIENT_SOCKET_ID));
            Assert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)((TypedValue)response.getSecond()).getValue())), (Matcher)CoreMatchers.equalTo((Object)new String((byte[])responseMessage.getValue())));
            Assert.assertThat((Object)serverSocketClosed.get(), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            serverSocket.close(WebSocketCloseCode.NORMAL_CLOSURE, "").get();
        }
        PollingProber.check((long)5000L, (long)100L, () -> ((Reference)serverSocketClosed).get());
    }

    private WebSocket connect(WebSocketCallback callback) throws Exception {
        Reference socket = new Reference();
        PollingProber.probe((long)5000L, (long)1000L, () -> {
            String uri = String.format("ws://localhost:%d%s", port.getNumber(), PATH);
            socket.set(client.openWebSocket(HttpRequest.builder().uri(uri).method("GET").addQueryParam("id", SERVER_CONNECTION_ID).build(), HttpRequestOptions.builder().responseTimeout(3000).followsRedirect(true).authentication(null).build(), CLIENT_SOCKET_ID, callback).get());
            return socket.get() != null;
        });
        return (WebSocket)socket.get();
    }

    private class TestWebSocketHandler
    implements WebSocketHandler {
        private final String path;
        private final WebSocketConnectionHandler connectionHandler;
        private final WebSocketMessageHandler messageHandler;
        private final long idleTimeoutMillis;

        public TestWebSocketHandler(String path, WebSocketConnectionHandler connectionHandler, WebSocketMessageHandler messageHandler) {
            this(path, connectionHandler, messageHandler, 30000L);
        }

        public TestWebSocketHandler(String path, WebSocketConnectionHandler connectionHandler, WebSocketMessageHandler messageHandler, long idleTimeoutMillis) {
            this.path = path;
            this.connectionHandler = connectionHandler;
            this.messageHandler = messageHandler;
            this.idleTimeoutMillis = idleTimeoutMillis;
        }

        public String getPath() {
            return this.path;
        }

        public WebSocketConnectionHandler getConnectionHandler() {
            return this.connectionHandler;
        }

        public WebSocketMessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        public long getIdleSocketTimeoutMills() {
            return this.idleTimeoutMillis;
        }
    }

    private class TestWebSocketCallback
    implements WebSocketCallback {
        private boolean connected;
        private boolean closed = false;
        private List<Pair<WebSocket, TypedValue<InputStream>>> messages = new CopyOnWriteArrayList<Pair<WebSocket, TypedValue<InputStream>>>();

        private TestWebSocketCallback() {
        }

        public void onConnect(WebSocket webSocket) {
            this.connected = true;
        }

        public void onClose(WebSocket webSocket, WebSocketCloseCode code, String reason) {
            this.closed = true;
        }

        public void onMessage(WebSocket webSocket, TypedValue<InputStream> content) {
            this.messages.add((Pair<WebSocket, TypedValue<InputStream>>)new Pair((Object)webSocket, content));
        }

        public boolean isConnected() {
            return this.connected;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public List<Pair<WebSocket, TypedValue<InputStream>>> getMessages() {
            return this.messages;
        }
    }
}

