/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl;

import static com.mulesoft.service.http.impl.AllureConstants.HttpFeature.HttpStory.MEMORY_MANAGEMENT;
import static com.mulesoft.service.http.impl.grizzly.memory.manager.MuleGrizzlyHeapMemoryManager.setMemoryManagerByteBufferProvider;
import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.ArgumentMatchers.anyInt;
import static org.mockito.Mockito.atLeastOnce;
import static org.mockito.Mockito.verify;

import com.mulesoft.service.http.impl.grizzly.memory.manager.MuleGrizzlyHeapMemoryManager;
import com.mulesoft.service.http.impl.service.memory.management.DefaultByteBufferProvider;
import org.junit.Rule;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeoutException;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterContext;
import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;
import io.qameta.allure.Story;
import io.qameta.allure.junit4.DisplayName;
import org.junit.After;
import org.junit.Before;;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.rule.SystemProperty;


@Story(MEMORY_MANAGEMENT)
@DisplayName("Validates that the memory management is being used.")
public class HttpMemoryManagementTestCase extends AbstractHttpClientTestCase {

  public static final String GRIZLY_DEFAULT_MEMORY_MANAGEMENT_PROPERTY = "org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER";

  @Rule
  public SystemProperty grizzlyMemoryManagement =
      new SystemProperty(GRIZLY_DEFAULT_MEMORY_MANAGEMENT_PROPERTY, MuleGrizzlyHeapMemoryManager.class.getName());

  @Rule
  public MockitoRule mockitorule = MockitoJUnit.rule();

  @Spy
  private ByteBufferProvider byteBufferProvider = new DefaultByteBufferProvider();

  private HttpClient client;

  @Parameterized.Parameters(name = "{0}")
  public static Iterable<Object[]> params() {
    if (ParameterContext.isParameterSet()) {
      return Collections.singletonList(ParameterContext.getParameter(Object[].class));
    } else {
      return Collections.singletonList(new String[] {EEHttpServiceImplementation.class.getName()});
    }
  }

  @Override
  public void createServices() throws Exception {
    super.createServices();
    setMemoryManagerByteBufferProvider(byteBufferProvider);
  }

  public HttpMemoryManagementTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @Override
  protected HttpResponse setUpHttpResponse(HttpRequest request) {
    HttpResponseBuilder responseBuilder = HttpResponse.builder();
    responseBuilder.statusCode(OK.getStatusCode());
    return responseBuilder.build();
  }

  @Before
  public void createClient() {
    client = service.getClientFactory().create(new HttpClientConfiguration.Builder()
        .setName("no-body-test")
        .build());
    client.start();
  }

  @After
  public void stopClient() {
    if (client != null) {
      client.stop();
    }
  }

  @Test
  public void byteBufferInvoked() throws Exception {
    assertEmptyOnStatus("/noContent", OK);
    verify(byteBufferProvider, atLeastOnce()).getByteArray(anyInt());
  }

  private void assertEmptyOnStatus(String path, HttpConstants.HttpStatus expectedStatus) throws IOException, TimeoutException {
    HttpResponse response = client.send(HttpRequest.builder().uri(getUri() + path).build());
    assertThat(response.getStatusCode(), is(expectedStatus.getStatusCode()));
    assertThat(response.getEntity().getBytesLength().isPresent(), is(true));
    assertThat(response.getEntity().getBytesLength().getAsLong(), is(0L));
  }
}
