/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.functional;

import static com.mulesoft.service.http.impl.service.client.EEGrizzlyHttpClient.refreshSystemProperties;
import static java.net.InetAddress.getByName;
import static java.util.Collections.singletonList;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mule.service.http.impl.functional.client.HttpClientProxyPropertiesTestCase;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.mulesoft.service.http.impl.service.client.EEHttpClientConnectionManager;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class HttpClientProxyPropertiesEeTestCase extends HttpClientProxyPropertiesTestCase {

  /**
   * Sets up a non working IP for the final host to guarantee it is not used, since the proxy should establish that connection.
   */
  @BeforeClass
  public static void setUpIp() throws UnknownHostException {
    InetAddress nonConnectableAddress = getByName("203.0.113.1");
    List<InetAddress> nonConnectableAddresses = singletonList(nonConnectableAddress);

    HostNameResolver hostNameResolver = mock(HostNameResolver.class);
    when(hostNameResolver.getRotatedAddresses("mulesoft.org")).thenReturn(nonConnectableAddresses);
    EEHttpClientConnectionManager.hostNameResolver = hostNameResolver;
  }

  @Before
  public void setUpRefresh() {
    refreshSystemProperties();
  }

  @AfterClass
  public static void tearDownRefresh() {
    refreshSystemProperties();
  }

  public HttpClientProxyPropertiesEeTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  /**
   * Differentiate the actual host from the proxy one to avoid clashes, this will not affect the proxy since "localhost" is hard
   * coded there as target host.
   */
  @Override
  protected String getUri() {
    return "http://mulesoft.org:" + port.getValue();
  }
}
