/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.functional;

import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;
import org.mule.service.http.impl.functional.HttpH2CUpgradeRequestTestCase;
import org.mule.service.http.impl.functional.client.HttpClientConfigurationDecompressionTestCase;
import org.mule.service.http.impl.functional.client.HttpClientMaxConnectionsTestCase;
import org.mule.service.http.impl.functional.client.HttpClientNoBodyTestCase;
import org.mule.service.http.impl.functional.client.HttpClientOutboundPartsTestCase;
import org.mule.service.http.impl.functional.client.HttpClientPartTypeTestCase;
import org.mule.service.http.impl.functional.client.HttpClientPropertyDecompressionTestCase;
import org.mule.service.http.impl.functional.client.HttpClientProxyTestCase;
import org.mule.service.http.impl.functional.client.HttpClientStreamingTestCase;
import org.mule.service.http.impl.functional.client.HttpPartDispositionTestCase;
import org.mule.service.http.impl.functional.client.NtlmHttpClientPostStreamingTestCase;
import org.mule.service.http.impl.functional.client.RedirectHttpClientPostStreamingTestCase;
import org.mule.service.http.impl.functional.client.HttpTransferLengthWithPayloadAllowedTestCase;
import org.mule.service.http.impl.functional.client.HttpTransferLengthWithPayloadDisallowedTestCase;
import org.mule.service.http.impl.functional.server.HttpServerBindTestCase;
import org.mule.service.http.impl.functional.server.HttpServerClientTimeoutTestCase;
import org.mule.service.http.impl.functional.server.HttpServerDelayedResponseTestCase;
import org.mule.service.http.impl.functional.server.HttpServerErrorRequestsTestCase;
import org.mule.service.http.impl.functional.server.HttpServerMixedPartTestCase;
import org.mule.service.http.impl.functional.server.HttpServerPartsTestCase;
import org.mule.service.http.impl.functional.server.HttpServerStatusCallbackTestCase;
import org.mule.service.http.impl.functional.server.HttpServerTimeoutTestCase;
import org.mule.service.http.impl.functional.server.HttpServerTransfer10TestCase;
import org.mule.service.http.impl.functional.server.HttpServerTransfer11TestCase;
import org.mule.service.http.impl.service.HttpServiceImplementationServerFactoryTestCase;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterizedSuite;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;
import org.junit.runners.Suite.SuiteClasses;

@RunWith(ParameterizedSuite.class)
@SuiteClasses({
    HttpClientProxyTestCase.class,
    HttpServerTimeoutTestCase.class,
    HttpClientMaxConnectionsTestCase.class,
    HttpClientOutboundPartsTestCase.class,
    HttpClientPartTypeTestCase.class,
    HttpClientStreamingTestCase.class,
    HttpClientNoBodyTestCase.class,
    HttpPartDispositionTestCase.class,
    HttpClientProxyPropertiesEeTestCase.class,
    HttpServerPartsTestCase.class,
    HttpServerMixedPartTestCase.class,
    HttpServerBindTestCase.class,
    HttpServerTransfer10TestCase.class,
    HttpServerTransfer11TestCase.class,
    HttpTransferLengthWithPayloadAllowedTestCase.class,
    HttpTransferLengthWithPayloadDisallowedTestCase.class,
    HttpServerClientTimeoutTestCase.class,
    HttpServerErrorRequestsTestCase.class,
    HttpServerDelayedResponseTestCase.class,
    NtlmHttpClientPostStreamingTestCase.class,
    RedirectHttpClientPostStreamingTestCase.class,
    HttpH2CUpgradeRequestTestCase.class,
    HttpClientConfigurationDecompressionTestCase.class,
    HttpClientPropertyDecompressionTestCase.class,
    HttpServerStatusCallbackTestCase.class,
    HttpServiceImplementationServerFactoryTestCase.class
})
public class HttpEeServiceTestCase {

  @Parameters(name = "{0}")
  public static Object[] params() {
    return new Object[][] {
        {EEHttpServiceImplementation.class.getName()}
    };
  }

  @Parameter(0)
  public String serviceToLoad;

}
