/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.functional.ws;

import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;

public abstract class AbstractWebSocketTestCase extends AbstractMuleTestCase {

  private static SimpleUnitTestSupportSchedulerService schedulerService;
  protected static EEHttpServiceImplementation service;
  protected static HttpClient client;
  protected static HttpServer server;

  @ClassRule
  public static DynamicPort port = new DynamicPort("port");

  protected WebSocketHandlerManager handlerManager;

  @BeforeClass
  public static void setupClass() throws Exception {
    schedulerService = new SimpleUnitTestSupportSchedulerService();
    service = new EEHttpServiceImplementation(schedulerService);
    service.start();

    server = service.getServerFactory().create(new HttpServerConfiguration.Builder()
        .setHost("localhost")
        .setPort(port.getNumber())
        .setName("ws-test")
        .build());
    server.start();

    client = service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("ws").build());
    client.start();
  }

  @AfterClass
  public static void afterClass() throws Exception {
    if (client != null) {
      client.stop();
    }

    if (server != null) {
      server.stop();
      server.dispose();
    }

    if (service != null) {
      service.stop();
    }

    if (schedulerService != null) {
      schedulerService.stop();
    }
  }

  @After
  public void after() {
    if (handlerManager != null) {
      handlerManager.stop();
      handlerManager.dispose();
    }
  }
}
