/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.functional.ws;

import static org.hamcrest.Matchers.containsString;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.tck.size.SmallTest;

import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@SmallTest
public class WebSocketServerTestCase extends AbstractWebSocketTestCase {

  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  private List<WebSocketHandlerManager> handlers = new ArrayList<>();

  @Test
  public void addRepeatedHandlers() {
    final String path = "/repeated";
    server.addWebSocketHandler(createMockHandler(path));

    expectedException.expect(MuleRuntimeException.class);
    expectedException.expectMessage(containsString("Already exists a listener matching that path and methods"));
    handlers.add(server.addWebSocketHandler(createMockHandler(path)));
  }

  @Test
  public void catchAllDoesntClashWithSpecific() {
    handlers.add(server.addWebSocketHandler(createMockHandler("/ws/*")));
    handlers.add(server.addWebSocketHandler(createMockHandler("/ws/specific")));
  }

  private WebSocketHandler createMockHandler(String path) {
    WebSocketHandler handler = mock(WebSocketHandler.class, RETURNS_DEEP_STUBS);
    when(handler.getPath()).thenReturn(path);

    return handler;
  }

  @After
  public void after() {
    handlers.forEach(h -> {
      h.stop();
      h.dispose();
    });
    super.after();
  }
}
