/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service;

import com.mulesoft.service.http.impl.grizzly.memory.manager.MuleGrizzlyHeapMemoryManager;
import com.mulesoft.service.http.impl.service.client.EEHttpClientConnectionManager;
import com.mulesoft.service.http.impl.service.server.EEHttpListenerConnectionManager;
import com.mulesoft.service.http.impl.service.ws.GrizzlyWebSocketBroadcaster;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.ws.WebSocketBroadcaster;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.HttpClientConnectionManager;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EEHttpServiceImplementation
extends HttpServiceImplementation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EEHttpServiceImplementation.class);
    public static final String HTTP_SERVICE_GRIZZLY_MEMORY_MANAGEMENT = "http.service.grizzly.memory.management";
    @Inject
    private MemoryManagementService memoryManagementService;

    public EEHttpServiceImplementation(SchedulerService schedulerService) {
        super(schedulerService);
    }

    protected HttpClientConnectionManager createClientConnectionManager() {
        return new EEHttpClientConnectionManager(this.schedulerService);
    }

    protected HttpListenerConnectionManager createListenerConnectionManager(SchedulerService schedulerService) {
        return new EEHttpListenerConnectionManager(schedulerService, SchedulerConfig.config());
    }

    public WebSocketBroadcaster newWebSocketBroadcaster() {
        return new GrizzlyWebSocketBroadcaster();
    }

    public String getName() {
        return "HTTP EE Service";
    }

    public void start() throws MuleException {
        if (this.memoryManagementService != null) {
            MuleGrizzlyHeapMemoryManager.setMemoryManagerByteBufferProvider(this.memoryManagementService.getByteBufferProvider(HTTP_SERVICE_GRIZZLY_MEMORY_MANAGEMENT, ByteBufferType.HEAP));
        } else {
            LOGGER.warn("Memory Management is null. This is not a managed EEHttpServiceImpementation. A default Byte Buffer Provider will be used by the Mule Memory Manager.");
        }
        super.start();
    }
}

