/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostNameIpsRing {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostNameIpsRing.class);
    private static final long cacheMaxTtl = Long.getLong(HostNameIpsRing.class.getName() + ".cache.maxTtl", 1000L);
    private static final long cacheRefreshTime = Long.getLong(HostNameIpsRing.class.getName() + ".cache.refreshTime", 100L);
    private final String hostName;
    private final AtomicInteger idxAddresses = new AtomicInteger(0);
    private InetAddress[] lastValues;
    private long lastRefreshTimestamp = -1L;
    private Lock refreshLock = new ReentrantLock();

    public HostNameIpsRing(String hostName) {
        this.hostName = hostName;
    }

    private List<InetAddress> getIpAddressesRotatedFromRelativeIndex(int idx) throws UnknownHostException {
        InetAddress[] addresses = this.getAddressesWithCache();
        int addressesCount = addresses.length;
        if (addressesCount == 1) {
            return Collections.singletonList(addresses[0]);
        }
        idx = Math.abs(idx % addressesCount);
        List<Object> addressesList = Arrays.asList(ArrayUtils.addAll((Object[])Arrays.copyOfRange(addresses, idx, addressesCount), (Object[])Arrays.copyOfRange(addresses, 0, idx)));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Host name {}: resolved ip addresses '{}' (base index {}).", new Object[]{this.hostName, addressesList.toString(), idx});
        }
        return addressesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InetAddress[] getAddressesWithCache() throws UnknownHostException {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastRefreshTimestamp > cacheMaxTtl) {
            this.refreshLock.lock();
            try {
                if (currentTimeMillis - this.lastRefreshTimestamp <= cacheMaxTtl) return this.lastValues;
                this.lastValues = InetAddress.getAllByName(this.hostName);
                this.lastRefreshTimestamp = currentTimeMillis;
                return this.lastValues;
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        if (currentTimeMillis - this.lastRefreshTimestamp <= cacheRefreshTime || !this.refreshLock.tryLock()) return this.lastValues;
        try {
            this.lastValues = InetAddress.getAllByName(this.hostName);
            this.lastRefreshTimestamp = currentTimeMillis;
            return this.lastValues;
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    public List<InetAddress> getRotatedIpAddresses() throws UnknownHostException {
        return this.getIpAddressesRotatedFromRelativeIndex(this.idxAddresses.getAndIncrement());
    }

    public List<InetAddress> getIpAddresses() throws UnknownHostException {
        return this.getIpAddressesRotatedFromRelativeIndex(this.idxAddresses.get());
    }
}

