/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.grizzly.memory.manager;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

import org.glassfish.grizzly.Buffer;

/**
 * A {@link ReadOnlyHeapBuffer} based on the grizzly implementation so that we can obtain the {@link ByteBuffer}'s from the mule
 * memory management.
 *
 * @see {@link org.glassfish.grizzly.memory.ReadOnlyHeapBuffer}
 */
public class ReadOnlyHeapBuffer extends HeapBuffer {

  // ------------------------------------------------------------ Constructors

  ReadOnlyHeapBuffer(byte[] heap, int offset, int cap) {
    super(heap, offset, cap);
  }

  // ------------------------------------------------- Methods from HeapBuffer

  @Override
  public HeapBuffer asReadOnlyBuffer() {
    return this;
  }

  @Override
  public boolean isReadOnly() {
    return true;
  }

  @Override
  public HeapBuffer prepend(Buffer header) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer put(int index, byte b) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer put(Buffer src) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer put(Buffer src, int position, int length) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public Buffer put(ByteBuffer src) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public Buffer put(ByteBuffer src, int position, int length) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer put(byte b) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer put(byte[] src) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer put(byte[] src, int offset, int length) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putChar(char value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putChar(int index, char value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putShort(short value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putShort(int index, short value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putInt(int value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putInt(int index, int value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putLong(long value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putLong(int index, long value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putFloat(float value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putFloat(int index, float value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putDouble(double value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  public HeapBuffer putDouble(int index, double value) {
    throw new ReadOnlyBufferException();
  }

  @Override
  protected HeapBuffer createHeapBuffer(final int offset, final int capacity) {
    return new ReadOnlyHeapBuffer(heap, offset, capacity);
  }

  @Override
  public ByteBuffer toByteBuffer() {
    return super.toByteBuffer().asReadOnlyBuffer();
  }

  @Override
  public ByteBuffer toByteBuffer(int position, int limit) {
    return super.toByteBuffer(position, limit).asReadOnlyBuffer();
  }
}
