/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.client;

import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.service.http.impl.service.client.HttpClientConnectionManager;

import com.mulesoft.service.http.impl.service.HostNameResolver;

/**
 * EE version of {@link HttpClientConnectionManager} which creates instances of {@link EEGrizzlyHttpClient}
 *
 * @since 1.3.0
 */
public class EEHttpClientConnectionManager extends HttpClientConnectionManager {

  public static HostNameResolver hostNameResolver = new HostNameResolver();

  public EEHttpClientConnectionManager(SchedulerService schedulerService) {
    super(schedulerService);
  }

  @Override
  public HttpClient create(HttpClientConfiguration config, SchedulerConfig schedulerConfig) {
    return new EEGrizzlyHttpClient(config, schedulerService, schedulerConfig, hostNameResolver);
  }

}
