/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.client.builder;

import static java.util.Collections.emptyList;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.service.http.impl.service.HostNameResolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

/**
 * Avoids any hostname resolution. Used when a proxy is set up via system properties.
 */
public class NoNameResolvingRequestHandler extends NameResolvingRequestBuilder {

  public NoNameResolvingRequestHandler(HttpRequest request, HostNameResolver hostNameResolver) {
    super(request, hostNameResolver);
  }

  @Override
  protected List<InetAddress> getAddresses() throws UnknownHostException {
    return emptyList();
  }

  @Override
  protected List<InetAddress> getRotateAddresses() throws UnknownHostException {
    return emptyList();
  }
}
