/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.builder;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.uri.Uri;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NameResolvingRequestBuilder
extends RequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(NameResolvingRequestBuilder.class);
    private static final String DISABLE_ROUND_ROBIN = "mule.http.disableRoundRobin";
    private static List<String> disabledRoundRobinHosts = System.getProperty("mule.http.disableRoundRobin") != null ? Arrays.asList(System.getProperty("mule.http.disableRoundRobin").split(",")) : Collections.emptyList();
    private final HostNameResolver hostNameResolver;
    private final String host;
    private Iterator<InetAddress> resolvedAddressesIterator;

    public NameResolvingRequestBuilder(HttpRequest request, HostNameResolver hostNameResolver) {
        super(request.getMethod(), true);
        this.hostNameResolver = hostNameResolver;
        this.host = request.getUri().getHost();
    }

    protected void initAddressesIterator(IpListFactory factory) {
        List<InetAddress> addresses = null;
        try {
            addresses = factory.getAddresses();
        }
        catch (UnknownHostException e) {
            logger.error("HostName '{}' could not be resolved ({})", (Object)this.host, (Object)e.getMessage());
        }
        this.resolvedAddressesIterator = addresses != null ? addresses.iterator() : Collections.emptyIterator();
    }

    public RequestBuilder setUrl(String url) {
        InetAddress nextResolvedAddresses = this.nextResolvedAddresses();
        if (nextResolvedAddresses != null) {
            this.setInetAddress(nextResolvedAddresses);
        }
        return super.setUrl(url);
    }

    public RequestBuilder setUri(Uri uri) {
        InetAddress nextResolvedAddresses = this.nextResolvedAddresses();
        if (nextResolvedAddresses != null) {
            this.setInetAddress(nextResolvedAddresses);
        }
        return (RequestBuilder)super.setUri(uri);
    }

    protected abstract List<InetAddress> getAddresses() throws UnknownHostException;

    protected abstract List<InetAddress> getRotateAddresses() throws UnknownHostException;

    public String getHost() {
        return this.host;
    }

    protected HostNameResolver getDomainNameResolver() {
        return this.hostNameResolver;
    }

    protected InetAddress nextResolvedAddresses() {
        if (this.resolvedAddressesIterator == null) {
            this.initAddressesIterator(disabledRoundRobinHosts.contains(this.host) ? new NonRotateIpListFactory() : new RotateIpListFactory());
        }
        return this.resolvedAddressesIterator.hasNext() ? this.resolvedAddressesIterator.next() : null;
    }

    public boolean hasNextResolvedAddresses() {
        if (this.resolvedAddressesIterator == null) {
            this.initAddressesIterator(new NonRotateIpListFactory());
        } else if (disabledRoundRobinHosts.contains(this.host)) {
            try {
                this.getRotateAddresses();
            }
            catch (UnknownHostException e) {
                logger.debug("HostName '{}' could not be resolved ({})", (Object)this.host, (Object)e.getMessage());
            }
        }
        return this.resolvedAddressesIterator.hasNext();
    }

    public static void setDisabledRoundRobinHosts(List<String> hosts) {
        disabledRoundRobinHosts = hosts;
    }

    private class NonRotateIpListFactory
    implements IpListFactory {
        private NonRotateIpListFactory() {
        }

        @Override
        public List<InetAddress> getAddresses() throws UnknownHostException {
            return NameResolvingRequestBuilder.this.getAddresses();
        }
    }

    private class RotateIpListFactory
    implements IpListFactory {
        private RotateIpListFactory() {
        }

        @Override
        public List<InetAddress> getAddresses() throws UnknownHostException {
            return NameResolvingRequestBuilder.this.getRotateAddresses();
        }
    }

    private static interface IpListFactory {
        public List<InetAddress> getAddresses() throws UnknownHostException;
    }
}

