/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.ws;

import com.mulesoft.service.http.impl.service.ws.DataFrameEmitter;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.utils.Futures;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;

public final class WebSocketUtils {
    public static final int DEFAULT_DATA_FRAME_SIZE = 8192;

    public static CompletableFuture<Void> streamInDataFrames(InputStream content, DataFrameEmitter emitter, Function<Throwable, Throwable> exceptionMapper) {
        return WebSocketUtils.streamInDataFrames(content, 8192, emitter, exceptionMapper);
    }

    public static CompletableFuture<Void> streamInDataFrames(InputStream content, int frameSize, DataFrameEmitter emitter, Function<Throwable, Throwable> exceptionMapper) {
        byte[] readBuffer = new byte[frameSize];
        byte[] writeBuffer = new byte[frameSize];
        int write = 0;
        boolean streaming = false;
        CompletionStage composedFuture = null;
        Latch latch = new Latch();
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        try {
            int read;
            while (error.get() == null && (read = content.read(readBuffer, 0, readBuffer.length)) != -1) {
                if (write > 0 && error.get() == null) {
                    streaming = true;
                    CompletionStage frameFuture = emitter.stream(writeBuffer, 0, write, false).whenComplete((v, e) -> {
                        if (e != null) {
                            error.set(e);
                            latch.release();
                        }
                    });
                    composedFuture = composedFuture == null ? frameFuture : composedFuture.thenCompose(arg_0 -> WebSocketUtils.lambda$streamInDataFrames$1((CompletableFuture)frameFuture, arg_0));
                }
                System.arraycopy(readBuffer, 0, writeBuffer, 0, read);
                write = read;
            }
            if (composedFuture != null) {
                composedFuture.whenComplete((v, e) -> latch.release());
                latch.await();
            }
            if (error.get() != null) {
                return WebSocketUtils.failedFuture(exceptionMapper.apply(error.get()));
            }
            if (write == 0) {
                return CompletableFuture.completedFuture(null);
            }
            if (write < writeBuffer.length) {
                byte[] exactSize = writeBuffer;
                writeBuffer = new byte[write];
                System.arraycopy(exactSize, 0, writeBuffer, 0, write);
            }
            if (error.get() != null) {
                return WebSocketUtils.failedFuture(exceptionMapper.apply(error.get()));
            }
            if (streaming) {
                return emitter.stream(writeBuffer, 0, write, true);
            }
            return emitter.send(writeBuffer, 0, write);
        }
        catch (Throwable t) {
            return WebSocketUtils.failedFuture(exceptionMapper.apply(t));
        }
    }

    public static <T> CompletableFuture<Void> asVoid(CompletableFuture<T> future) {
        return WebSocketUtils.asVoid(future, Function.identity());
    }

    public static <T> CompletableFuture<Void> asVoid(CompletableFuture<T> future, Function<Throwable, Throwable> exceptionMapper) {
        CompletableFuture<Void> vf = new CompletableFuture<Void>();
        future.whenComplete((v, e) -> {
            if (e != null) {
                vf.completeExceptionally((Throwable)exceptionMapper.apply((Throwable)e));
            } else {
                vf.complete(null);
            }
        });
        return vf;
    }

    public static <T> CompletableFuture<Void> asVoid(GrizzlyFuture<T> future) {
        return WebSocketUtils.asVoid(future, Function.identity());
    }

    public static <T> CompletableFuture<Void> asVoid(GrizzlyFuture<T> future, Function<Throwable, Throwable> exceptionMapper) {
        return WebSocketUtils.asVoid(Futures.completable(future), exceptionMapper);
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static Throwable mapWsException(Throwable t, WebSocket webSocket) {
        if (t instanceof RuntimeException && ("Socket is already closed.".equals(t.getMessage()) || "Socket is not connected.".equals(t.getMessage()))) {
            return new WebSocketConnectionException(webSocket, t);
        }
        return t;
    }

    private static /* synthetic */ CompletionStage lambda$streamInDataFrames$1(CompletableFuture frameFuture, Void v) {
        return frameFuture;
    }
}

