/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.memory.management;

import org.mule.runtime.api.memory.provider.ByteBufferProvider;

import java.nio.ByteBuffer;

/**
 * A {@link ByteBufferProvider} that simply returns bytebuffers and arrays without any further processing.
 *
 * @since 1.5.0
 */
public class DefaultByteBufferProvider implements ByteBufferProvider {

  @Override
  public ByteBuffer allocate(int size) {
    return ByteBuffer.allocate(size);
  }

  @Override
  public ByteBuffer allocateAtLeast(int size) {
    return ByteBuffer.allocate(size);
  }

  @Override
  public ByteBuffer reallocate(ByteBuffer oldBuffer, int newSize) {
    return ByteBuffer.allocate(newSize);
  }

  @Override
  public void release(ByteBuffer buffer) {
    // Nothing to do.
  }

  @Override
  public byte[] getByteArray(int size) {
    return new byte[size];
  }

  @Override
  public void dispose() {
    // Nothing to do.
  }
}
