/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.server;

import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

/**
 * EE implementation of {@link GrizzlyServerManager}
 *
 * @since 1.3.0
 */
public class EEGrizzlyServerManager extends GrizzlyServerManager {

  public EEGrizzlyServerManager(ExecutorService selectorPool, ExecutorService workerPool,
                                ExecutorService idleTimeoutExecutorService,
                                HttpListenerRegistry httpListenerRegistry,
                                TcpServerSocketProperties serverSocketProperties, int selectorCount) {
    super(selectorPool, workerPool, idleTimeoutExecutorService, httpListenerRegistry, serverSocketProperties, selectorCount);
  }

  @Override
  protected GrizzlyServerManager.ManagedGrizzlyHttpServer createManagedServer(Supplier<Scheduler> schedulerSupplier,
                                                                              ServerAddress serverAddress,
                                                                              ServerIdentifier identifier,
                                                                              Supplier<Long> shutdownTimeout) {
    return new ManagedGrizzlyHttpServer(new EEGrizzlyHttpServer(serverAddress,
                                                                transport,
                                                                httpListenerRegistry,
                                                                schedulerSupplier,
                                                                () -> executorProvider.removeExecutor(serverAddress),
                                                                sslFilterDelegate,
                                                                webSocketFilter,
                                                                shutdownTimeout),
                                        identifier);
  }
}
