/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.builder;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.mulesoft.service.http.impl.service.client.builder.NameResolvingRequestBuilder;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.uri.Uri;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public class ProxyNameResolvingRequestBuilder
extends NameResolvingRequestBuilder {
    private final ProxyConfig proxyConfig;

    public ProxyNameResolvingRequestBuilder(HttpRequest request, HostNameResolver hostNameResolver, ProxyConfig proxyConfig) {
        super(request, hostNameResolver);
        this.proxyConfig = proxyConfig;
    }

    @Override
    protected List<InetAddress> getAddresses() throws UnknownHostException {
        return this.getDomainNameResolver().getAddresses(this.proxyConfig.getHost());
    }

    @Override
    protected List<InetAddress> getRotateAddresses() throws UnknownHostException {
        return this.getDomainNameResolver().getRotatedAddresses(this.proxyConfig.getHost());
    }

    @Override
    public RequestBuilder setUrl(String url) {
        this.setProxyServer(this.buildProxy(this.proxyConfig));
        return super.setUrl(url);
    }

    @Override
    public RequestBuilder setUri(Uri uri) {
        this.setProxyServer(this.buildProxy(this.proxyConfig));
        return super.setUri(uri);
    }

    protected final ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty((String)proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof ProxyConfig.NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((ProxyConfig.NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        if (proxyConfig.getNonProxyHosts() != null && !proxyConfig.getNonProxyHosts().isEmpty()) {
            for (String host : proxyConfig.getNonProxyHosts().split(",")) {
                proxyServer.addNonProxyHost(host.trim());
            }
        }
        return proxyServer;
    }
}

