/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.client.ws.reconnect;

import static com.mulesoft.service.http.impl.service.ws.WebSocketUtils.mapWsException;

import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.ws.WebSocket;

import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;

import java.util.concurrent.CompletableFuture;

/**
 * Reconnects a {@link WebSocket} by replaying an original {@link HttpRequest}. The newly obtained {@link WebSocket} will have the
 * same ID and {@link WebSocketCallback} as the original.
 *
 * @since 1.5.0
 */
public class OutboundWebSocketReconnectionHandler {

  private final HttpClient httpClient;
  private final HttpRequest request;
  private final HttpRequestOptions requestOptions;
  private final String socketId;
  private final WebSocketCallback callback;

  /**
   * Creates a new instance.
   *
   * @param httpClient     the client used to create the new {@link WebSocket}
   * @param request        the original request
   * @param requestOptions the original request options
   * @param socketId       the original socketId
   * @param callback       the original {@link {@link WebSocketCallback}}
   */
  public OutboundWebSocketReconnectionHandler(HttpClient httpClient,
                                              HttpRequest request,
                                              HttpRequestOptions requestOptions,
                                              String socketId,
                                              WebSocketCallback callback) {
    this.httpClient = httpClient;
    this.request = request;
    this.requestOptions = requestOptions;
    this.socketId = socketId;
    this.callback = callback;
  }

  public CompletableFuture<WebSocket> reconnect(OutboundWebSocket webSocket,
                                                RetryPolicyTemplate retryPolicyTemplate,
                                                Scheduler scheduler) {
    return retryPolicyTemplate.applyPolicy(() -> httpClient.openWebSocket(request, requestOptions, socketId, callback),
                                           t -> !webSocket.isClosed(),
                                           t -> {
                                           },
                                           t -> {
                                           },
                                           t -> mapWsException(t, webSocket),
                                           scheduler);
  }
}
