/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.server;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import static org.mule.service.http.impl.config.ContainerTcpServerSocketProperties.loadTcpServerSocketProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

/**
 * EE implementation of {@link HttpListenerConnectionManager}
 *
 * @since 1.3.0
 */
public class EEHttpListenerConnectionManager extends HttpListenerConnectionManager {

  public EEHttpListenerConnectionManager(SchedulerService schedulerService, SchedulerConfig schedulersConfig) {
    super(schedulerService, schedulersConfig);
  }

  @Override
  protected GrizzlyServerManager createServerManager() throws InitialisationException {
    try {
      return new EEGrizzlyServerManager(selectorScheduler, workerScheduler, idleTimeoutScheduler, httpListenerRegistry,
                                        loadTcpServerSocketProperties(), DEFAULT_SELECTOR_THREAD_COUNT);
    } catch (MuleException e) {
      throw new InitialisationException(createStaticMessage("Could not load server socket properties."), e, this);
    }
  }
}
