/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.ws;

import java.util.concurrent.CompletableFuture;

/**
 * Abstraction to send data frames hiding the complexities of the underlying transport
 *
 * @since 1.3.0
 */
public interface DataFrameEmitter {

  /**
   * Sends the given {@code bytes} as part of a stream. The stream will only be considered finished when {@code last} is
   * {@code true}.
   *
   * @param bytes  the data to be sent
   * @param offset the offset of the {@code data}
   * @param len    how many bytes to send starting from the {@code offset}
   * @param last   whether this is the final piece of the stream or not
   * @return a {@link CompletableFuture}
   */
  CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last);

  /**
   * Sends the given {@code bytes} as a single data frame
   *
   * @param bytes  the data to be sent
   * @param offset the offset of the {@code data}
   * @param len    how many bytes to send starting from the {@code offset}
   * @return a {@link CompletableFuture}
   */
  CompletableFuture<Void> send(byte[] bytes, int offset, int len);
}
