/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.service.ws;

import java.util.function.Consumer;

/**
 * Provides instances of {@link FragmentHandler}. Implementations should not only be thread safe, they are ment to abstract the
 * logic to decide when should a fragment be reused and when should a new one be spawned.
 *
 * @since 1.3.0
 */
public interface FragmentHandlerProvider {

  /**
   * Provides instances of {@link FragmentHandler}. Depending on the streaming scenario, subsequent invokations to this method
   * might return new or previous instances. If a new instance is returned, then the provided {@code newFragmentHandlerCallback}
   * will be invoked before the value is returned
   *
   * @param newFragmentHandlerCallback a callback to notify that a new instance will be returned
   * @return a {@link FragmentHandler}
   */
  FragmentHandler getFragmentHandler(Consumer<FragmentHandler> newFragmentHandlerCallback);
}
