/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl;

import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.scheduler.SchedulerService;

public class TestEEHttpServiceImplementation
extends EEHttpServiceImplementation {
    private final MemoryManagementService memoryManagementService;
    private final TestByteBufferProvider byteBufferProvider = new TestByteBufferProvider();

    public TestEEHttpServiceImplementation(SchedulerService schedulerService) {
        super(schedulerService);
        this.memoryManagementService = new TestMemoryManagementService(this.byteBufferProvider);
    }

    public MemoryManagementService getMemoryManagementService() {
        return this.memoryManagementService;
    }

    public long getAllocatedBytes() {
        return this.byteBufferProvider.getAllocatedBytes();
    }

    private static class TestByteBufferProvider
    implements ByteBufferProvider<ByteBuffer> {
        public AtomicLong allocatedBytes = new AtomicLong();

        private TestByteBufferProvider() {
        }

        public ByteBuffer allocate(int i) {
            this.allocatedBytes.addAndGet(i);
            return ByteBuffer.allocate(i);
        }

        public ByteBuffer allocateAtLeast(int i) {
            return ByteBuffer.allocate(i);
        }

        public ByteBuffer reallocate(ByteBuffer byteBuffer, int i) {
            return ByteBuffer.allocate(i);
        }

        public void release(ByteBuffer byteBuffer) {
        }

        public byte[] getByteArray(int i) {
            return new byte[i];
        }

        public void dispose() {
        }

        public long getAllocatedBytes() {
            return this.allocatedBytes.get();
        }
    }

    private static class TestMemoryManagementService
    implements MemoryManagementService {
        private final ByteBufferProvider<ByteBuffer> testByteBufferProvider;

        public TestMemoryManagementService(ByteBufferProvider<ByteBuffer> testByteBufferProvider) {
            this.testByteBufferProvider = testByteBufferProvider;
        }

        public ByteBufferProvider<ByteBuffer> getByteBufferProvider(String s, ByteBufferType byteBufferType, ByteBufferPoolConfiguration byteBufferPoolConfiguration) {
            return this.testByteBufferProvider;
        }

        public ByteBufferProvider<ByteBuffer> getByteBufferProvider(String s, ByteBufferType byteBufferType) {
            return this.testByteBufferProvider;
        }

        public void disposeByteBufferProvider(String s) {
        }

        public void dispose() {
        }

        public void initialise() {
        }
    }
}

