/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;
import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocketListener;
import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import com.ning.http.client.HttpResponseBodyPart;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class OutboundWebSocketListenerTestCase
extends AbstractMuleTestCase {
    private OutboundWebSocketListener listener;
    private WebSocketCallback webSocketCallback;
    private com.ning.http.client.ws.WebSocket grizzlyWebSocket;
    private OutboundWebSocket muleWebSocket;
    private FragmentHandler fragmentHandler;

    @Before
    public void setUp() throws IOException {
        this.webSocketCallback = (WebSocketCallback)Mockito.mock(WebSocketCallback.class);
        this.listener = (OutboundWebSocketListener)Mockito.spy((Object)new OutboundWebSocketListener("ws-id", this.webSocketCallback));
        this.grizzlyWebSocket = (com.ning.http.client.ws.WebSocket)Mockito.mock(com.ning.http.client.ws.WebSocket.class);
        this.muleWebSocket = (OutboundWebSocket)Mockito.mock(OutboundWebSocket.class);
        this.fragmentHandler = (FragmentHandler)Mockito.mock(FragmentHandler.class);
        Mockito.when((Object)this.fragmentHandler.write((byte[])ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.muleWebSocket.getFragmentHandler((Consumer)ArgumentMatchers.any())).thenReturn((Object)this.fragmentHandler);
    }

    @Test
    public void whenSetSocketAfterOnOpen_thenOnConnectIsInvoked() {
        this.listener.onOpen(this.grizzlyWebSocket);
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback, (VerificationMode)Mockito.never())).onConnect((WebSocket)this.muleWebSocket);
        this.listener.setSocket(this.muleWebSocket);
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onConnect((WebSocket)this.muleWebSocket);
    }

    @Test
    public void whenOnOpenAfterSetSocket_thenOnConnectIsInvoked() {
        this.listener.setSocket(this.muleWebSocket);
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback, (VerificationMode)Mockito.never())).onConnect((WebSocket)this.muleWebSocket);
        this.listener.onOpen(this.grizzlyWebSocket);
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onConnect((WebSocket)this.muleWebSocket);
    }

    @Test
    public void onCloseAdaptsCode() {
        this.listener.setSocket(this.muleWebSocket);
        this.listener.onClose(this.grizzlyWebSocket, 1001, "My reason");
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onClose((WebSocket)this.muleWebSocket, WebSocketCloseCode.ENDPOINT_GOING_DOWN, "My reason");
    }

    @Test
    public void onCloseDefaultCode() {
        this.listener.setSocket(this.muleWebSocket);
        this.listener.onClose(this.grizzlyWebSocket);
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onClose((WebSocket)this.muleWebSocket, WebSocketCloseCode.NORMAL_CLOSURE, "");
    }

    @Test
    @Issue(value="W-17846088")
    public void onClosePrivateCode() {
        this.listener.setSocket(this.muleWebSocket);
        this.listener.onClose(this.grizzlyWebSocket, 4099, "custom private code");
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onClose((WebSocket)this.muleWebSocket, WebSocketCloseCode.UNKNOWN, "custom private code");
    }

    @Test(expected=IllegalArgumentException.class)
    @Issue(value="W-17846088")
    public void onCloseInvalidCode() {
        this.listener.setSocket(this.muleWebSocket);
        this.listener.onClose(this.grizzlyWebSocket, 111, "invalid code");
    }

    @Test
    public void onBinaryMessage() {
        ArgumentCaptor typedValueCaptor = ArgumentCaptor.forClass(TypedValue.class);
        this.listener.setSocket(this.muleWebSocket);
        this.listener.onMessage("My message".getBytes());
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onMessage((WebSocket)ArgumentMatchers.eq((Object)this.muleWebSocket), (TypedValue)typedValueCaptor.capture());
        TypedValue value = (TypedValue)typedValueCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getDataType().getMediaType(), (Matcher)Matchers.is((Object)MediaType.BINARY));
    }

    @Test
    public void onTextMessage() {
        ArgumentCaptor typedValueCaptor = ArgumentCaptor.forClass(TypedValue.class);
        this.listener.setSocket(this.muleWebSocket);
        this.listener.onMessage("My message");
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onMessage((WebSocket)ArgumentMatchers.eq((Object)this.muleWebSocket), (TypedValue)typedValueCaptor.capture());
        TypedValue value = (TypedValue)typedValueCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getDataType(), (Matcher)Matchers.is((Object)DataType.TEXT_STRING));
    }

    @Test
    public void onFragment_writeIsCalled() throws IOException {
        this.listener.setSocket(this.muleWebSocket);
        byte[] fragmentBytes = "Fragment".getBytes();
        HttpResponseBodyPart fragment = (HttpResponseBodyPart)Mockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)fragment.getBodyPartBytes()).thenReturn((Object)fragmentBytes);
        this.listener.onFragment(fragment);
        ((FragmentHandler)Mockito.verify((Object)this.fragmentHandler)).write(fragmentBytes);
    }

    @Test
    public void whenWriteReturnsFalse_itIsNotAborted() throws IOException {
        this.listener.setSocket(this.muleWebSocket);
        byte[] fragmentBytes = "Fragment".getBytes();
        HttpResponseBodyPart fragment = (HttpResponseBodyPart)Mockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)fragment.getBodyPartBytes()).thenReturn((Object)fragmentBytes);
        Mockito.when((Object)this.fragmentHandler.write(fragmentBytes)).thenReturn((Object)false);
        this.listener.onFragment(fragment);
        ((FragmentHandler)Mockito.verify((Object)this.fragmentHandler, (VerificationMode)Mockito.never())).abort();
    }

    @Test
    public void whenWriteRaisesException_itIsAborted() throws IOException {
        this.listener.setSocket(this.muleWebSocket);
        byte[] fragmentBytes = "Fragment".getBytes();
        HttpResponseBodyPart fragment = (HttpResponseBodyPart)Mockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)fragment.getBodyPartBytes()).thenReturn((Object)fragmentBytes);
        Mockito.when((Object)this.fragmentHandler.write(fragmentBytes)).thenThrow(new Throwable[]{new IOException("Expected")});
        this.listener.onFragment(fragment);
        ((FragmentHandler)Mockito.verify((Object)this.fragmentHandler)).abort();
    }

    @Test
    public void lastFragmentCompletesTheHandler() {
        this.listener.setSocket(this.muleWebSocket);
        byte[] fragmentBytes = "Fragment".getBytes();
        HttpResponseBodyPart fragment = (HttpResponseBodyPart)Mockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)fragment.getBodyPartBytes()).thenReturn((Object)fragmentBytes);
        Mockito.when((Object)fragment.isLast()).thenReturn((Object)true);
        this.listener.onFragment(fragment);
        ((FragmentHandler)Mockito.verify((Object)this.fragmentHandler)).complete();
    }

    @Test
    public void onFragmentMessageCallbackCallsOnMessageWithABinaryValue() throws IOException {
        ArgumentCaptor onMessageCallbackCaptor = ArgumentCaptor.forClass(Consumer.class);
        this.listener.setSocket(this.muleWebSocket);
        byte[] fragmentBytes = "Fragment".getBytes();
        HttpResponseBodyPart fragment = (HttpResponseBodyPart)Mockito.mock(HttpResponseBodyPart.class);
        Mockito.when((Object)fragment.getBodyPartBytes()).thenReturn((Object)fragmentBytes);
        this.listener.onFragment(fragment);
        ((OutboundWebSocket)Mockito.verify((Object)this.muleWebSocket)).getFragmentHandler((Consumer)onMessageCallbackCaptor.capture());
        Consumer onMessageCallback = (Consumer)onMessageCallbackCaptor.getValue();
        onMessageCallback.accept(this.fragmentHandler);
        ArgumentCaptor typedValueCaptor = ArgumentCaptor.forClass(TypedValue.class);
        ((WebSocketCallback)Mockito.verify((Object)this.webSocketCallback)).onMessage((WebSocket)ArgumentMatchers.eq((Object)this.muleWebSocket), (TypedValue)typedValueCaptor.capture());
        TypedValue typedValue = (TypedValue)typedValueCaptor.getValue();
        MatcherAssert.assertThat((Object)typedValue.getDataType().getMediaType(), (Matcher)Matchers.is((Object)MediaType.BINARY));
    }

    @Test
    public void onErrorDoesNotRethrowException() {
        try {
            this.listener.onError((Throwable)new RuntimeException("Don't rethrow this"));
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }
}

