/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.platform.OCSClient;
import com.mulesoft.service.oauth.internal.platform.OCSSettings;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.listener.OAuthStateListener;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.service.oauth.internal.AbstractOAuthDancer;
import org.mule.service.oauth.internal.state.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlatformManagedDancer
extends AbstractOAuthDancer
implements PlatformManagedOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlatformManagedDancer.class);
    private final OCSClient ocsClient;
    private final String connectionUri;
    private boolean accessTokenRefreshedOnStart = false;

    public DefaultPlatformManagedDancer(String name, String connectionUri, String organizationId, String platformUrl, OCSClient.OCSClientFactory ocsClientFactory, OAuthService oauthService, String clientId, String clientSecret, String tokenUrl, String scopes, ClientCredentialsLocation clientCredentialsLocation, Charset encoding, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExtractorsExprs, Function<String, String> resourceOwnerIdTransformer, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator, List<? extends OAuthStateListener> listeners) {
        super(name, clientId, clientSecret, tokenUrl, encoding, scopes, clientCredentialsLocation, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExtractorsExprs, resourceOwnerIdTransformer, schedulerService, lockProvider, tokensStore, httpClient, expressionEvaluator, listeners);
        OCSSettings settings = new OCSSettings(platformUrl, tokenUrl, clientId, clientSecret, encoding, clientCredentialsLocation, organizationId);
        this.ocsClient = ocsClientFactory.create(httpClient, settings, (ExpressionLanguage)expressionEvaluator, oauthService);
        this.ocsClient.initCoreServicesDancer(lockProvider, tokensStore, expressionEvaluator);
        this.connectionUri = connectionUri;
    }

    public void start() throws MuleException {
        super.start();
        try {
            this.accessToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (CompletionException | ExecutionException e) {
            this.stop();
            throw new LifecycleException(e.getCause(), (Object)this);
        }
        catch (InterruptedException e) {
            this.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public CompletableFuture<String> accessToken() {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.doFetchAccessToken();
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored for connection URI {} token has been invalidated. Refreshing...", (Object)this.connectionUri);
            return this.doFetchAccessToken();
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    private CompletableFuture<String> doFetchAccessToken() {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doAccessTokenRequest((ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doRefreshTokenRequest((ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    public CompletableFuture<PlatformManagedConnectionDescriptor> getConnectionDescriptor() {
        try {
            return this.ocsClient.getConnectionDescriptor(this.connectionUri);
        }
        catch (Throwable t) {
            return ConcurrencyUtils.exceptionallyCompleted((Throwable)t);
        }
    }

    private CompletableFuture<String> doAccessTokenRequest(ResourceOwnerOAuthContextWithRefreshState defaultUserState) {
        try {
            return ((CompletableFuture)this.ocsClient.getAccessToken(this.connectionUri).thenApply(response -> {
                String url = this.ocsClient.getAccessTokenUrl(this.connectionUri);
                TokenResponse tokenResponse = this.parseTokenResponseAndUpdateState((HttpResponse)response, url, defaultUserState, l -> l.onAccessToken((ResourceOwnerOAuthContext)defaultUserState));
                return tokenResponse.getAccessToken();
            })).exceptionally(this.tokenUrlExceptionHandler((ResourceOwnerOAuthContext)defaultUserState));
        }
        catch (RequestAuthenticationException e) {
            return ConcurrencyUtils.exceptionallyCompleted((Throwable)e);
        }
    }

    private CompletableFuture<Void> doRefreshTokenRequest(ResourceOwnerOAuthContextWithRefreshState defaultUserState) {
        try {
            return ((CompletableFuture)this.ocsClient.refreshToken(this.connectionUri).thenApply(response -> {
                String url = this.ocsClient.getRefreshTokenUrl(this.connectionUri);
                this.parseTokenResponseAndUpdateState((HttpResponse)response, url, defaultUserState, l -> l.onTokenRefreshed((ResourceOwnerOAuthContext)defaultUserState));
                return null;
            })).exceptionally(this.tokenUrlExceptionHandler((ResourceOwnerOAuthContext)defaultUserState));
        }
        catch (RequestAuthenticationException e) {
            return ConcurrencyUtils.exceptionallyCompleted((Throwable)e);
        }
    }

    private TokenResponse parseTokenResponseAndUpdateState(HttpResponse response, String tokenUrl, ResourceOwnerOAuthContextWithRefreshState defaultUserState, Consumer<PlatformManagedOAuthStateListener> listenerAction) {
        TokenResponse tokenResponse = this.parseTokenResponse(response, tokenUrl, false);
        ClassUtils.withContextClassLoader((ClassLoader)DefaultPlatformManagedDancer.class.getClassLoader(), () -> {
            LOGGER.debug("Retrieved access token and expires from token url are: {}, {}", (Object)tokenResponse.getAccessToken(), (Object)tokenResponse.getExpiresIn());
            defaultUserState.setAccessToken(tokenResponse.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
            for (Map.Entry customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateOAuthContextAfterTokenResponse((ResourceOwnerOAuthContext)defaultUserState);
            this.forEachListener(listenerAction);
        });
        return tokenResponse;
    }

    protected TokenResponse parseTokenResponse(HttpResponse response, String tokenUrl, boolean retrieveRefreshToken) {
        if (response.getStatusCode() == HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()) {
            InputStream content = response.getEntity().getContent();
            try {
                throw new CompletionException((Throwable)new TokenNotFoundException(tokenUrl, response, IOUtils.toString((InputStream)content)));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable)content);
                throw throwable;
            }
        }
        return super.parseTokenResponse(response, tokenUrl, retrieveRefreshToken);
    }

    public void addListener(PlatformManagedOAuthStateListener listener) {
        this.doAddListener((OAuthStateListener)listener);
    }

    public void removeListener(PlatformManagedOAuthStateListener listener) {
        this.doRemoveListener((OAuthStateListener)listener);
    }

    public void invalidateContext() {
        this.invalidateContext("default");
    }

    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }

    private void forEachListener(Consumer<PlatformManagedOAuthStateListener> action) {
        this.onEachListener(listener -> action.accept((PlatformManagedOAuthStateListener)listener));
    }
}

