/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mulesoft.service.oauth.internal.platform.DefaultPlatformManagedDancer;
import com.mulesoft.service.oauth.internal.platform.OCSClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.builder.AbstractOAuthDancerBuilder;

public class DefaultOAuthPlatformManagedDancerBuilder
extends AbstractOAuthDancerBuilder<PlatformManagedOAuthDancer>
implements OAuthPlatformManagedDancerBuilder {
    private final List<PlatformManagedOAuthStateListener> listeners = new ArrayList<PlatformManagedOAuthStateListener>(2);
    private final OAuthService oauthService;
    private final OCSClient.OCSClientFactory ocsClientFactory;
    private String connectionUri;
    private String organizationId;
    private String platformUrl;

    public DefaultOAuthPlatformManagedDancerBuilder(OAuthService oauthService, OCSClient.OCSClientFactory ocsClientFactory, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, LoadingCache<Pair<TlsContextFactory, ProxyConfig>, HttpClient> httpClientCache, MuleExpressionLanguage expressionEvaluator) {
        super(schedulerService, lockProvider, tokensStore, httpClientCache, expressionEvaluator);
        this.ocsClientFactory = ocsClientFactory;
        this.oauthService = oauthService;
    }

    public OAuthPlatformManagedDancerBuilder connectionUri(String connectionUri) {
        this.connectionUri = connectionUri;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder platformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder addListener(PlatformManagedOAuthStateListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    public PlatformManagedOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.platformUrl), (String)"platformUrl cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.connectionUri), (String)"connectionUri cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.organizationId), (String)"organizationId cannot be blank");
        return new DefaultPlatformManagedDancer(this.name, this.connectionUri, this.organizationId, this.platformUrl, this.ocsClientFactory, this.oauthService, this.clientId, this.clientSecret, this.tokenUrl, this.scopes, this.clientCredentialsLocation, this.encoding, this.responseAccessTokenExpr, this.responseRefreshTokenExpr, this.responseExpiresInExpr, this.customParametersExtractorsExprs, this.resourceOwnerIdTransformer, this.schedulerService, this.lockProvider, this.tokensStore, (HttpClient)this.httpClientFactory.get(), this.expressionEvaluator, this.listeners);
    }
}

