/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.oauth.internal;

import static com.mulesoft.service.oauth.internal.platform.OCSClient.getFactory;

import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.DefaultOAuthService;

import com.mulesoft.service.oauth.internal.platform.DefaultOAuthPlatformManagedDancerBuilder;

import java.util.Map;

/**
 * Extends the functionality of {@link DefaultOAuthService} with functionality only available for Mule EE
 *
 * @since 1.0
 */
public class EEOAuthService extends DefaultOAuthService {

  /**
   * Creates a new instance
   *
   * @param httpService          the {@link HttpService} used to creating clients and inbound endpoints
   * @param schedulerService     the {@link SchedulerService} used to schedule tasks
   */
  public EEOAuthService(HttpService httpService, SchedulerService schedulerService) {
    super(httpService, schedulerService);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public <T> OAuthPlatformManagedDancerBuilder platformManagedOAuthDancerBuilder(LockFactory lockFactory,
                                                                                 Map<String, T> tokenStore,
                                                                                 MuleExpressionLanguage expressionEvaluator) {
    return new DefaultOAuthPlatformManagedDancerBuilder(this,
                                                        getFactory(),
                                                        schedulerService,
                                                        lockFactory,
                                                        (Map<String, ResourceOwnerOAuthContext>) tokenStore,
                                                        httpClientFactory,
                                                        expressionEvaluator);
  }
}
