/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.platform.DefaultPlatformManagedConnectionDescriptor;
import com.mulesoft.service.oauth.internal.platform.ImmutablePlatformManagedConnectionDescriptor;
import com.mulesoft.service.oauth.internal.platform.OCSSettings;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSClient
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCSClient.class);
    private static final DataType CONNECTION_DESCRIPTOR_DATA_TYPE = DataType.fromType(DefaultPlatformManagedConnectionDescriptor.class);
    private static final String DESCRIPTOR_MAPPING_EXPRESSION = "#[{ id : payload.id, displayName: payload.displayName, uri : payload.uri, parameters:  payload.parameters}]";
    private static final HttpRequestOptions OCS_REQUEST_OPTIONS = HttpRequestOptions.builder().responseTimeout(60000).build();
    private static final String DEFAULT_API_VERSION = "v1";
    private static final String API_PREFIX_FORMAT = "/api/%s";
    public static final String REVISION_TOKEN_QUERY_PARAM = "rev";
    private final HttpClient httpClient;
    private final OCSSettings settings;
    private final OAuthService oauthService;
    private final ExpressionLanguage expressionLanguage;
    private final String apiPrefix;
    private ClientCredentialsOAuthDancer dancer;

    public static OCSClientFactory getFactory() {
        return new OCSClientFactory();
    }

    private OCSClient(HttpClient httpClient, OCSSettings settings, ExpressionLanguage expressionLanguage, OAuthService oauthService) {
        this.httpClient = httpClient;
        this.settings = settings;
        this.expressionLanguage = expressionLanguage;
        this.oauthService = oauthService;
        this.apiPrefix = this.getApiPrefix(settings);
    }

    private String getApiPrefix(OCSSettings settings) {
        String apiVersion = settings.getApiVersion();
        return String.format(API_PREFIX_FORMAT, apiVersion == null ? DEFAULT_API_VERSION : apiVersion);
    }

    public void stop() throws MuleException {
        this.httpClient.stop();
    }

    public CompletableFuture<HttpResponse> getAccessToken(String connectionUri) throws RequestAuthenticationException {
        LOGGER.info("Fetching access token for connection {}", (Object)connectionUri);
        return this.getCoreServicesAccessToken().thenCompose(csToken -> {
            String uri = this.getAccessTokenUrl(connectionUri);
            return this.ocsRequest((String)csToken, uri, HttpConstants.Method.GET);
        });
    }

    public CompletableFuture<HttpResponse> refreshToken(String connectionUri, String revisionToken) throws RequestAuthenticationException {
        LOGGER.info("Refreshing token for connection {} using lastUpdatedTimestamp {}", (Object)connectionUri, (Object)revisionToken);
        return this.getCoreServicesAccessToken().thenCompose(csToken -> {
            String uri = this.getRefreshTokenUrl(connectionUri);
            MultiMap.StringMultiMap queryParams = new MultiMap.StringMultiMap();
            if (revisionToken != null) {
                queryParams.put((Object)REVISION_TOKEN_QUERY_PARAM, (Object)revisionToken);
            }
            return this.ocsRequest((String)csToken, uri, HttpConstants.Method.POST, (MultiMap<String, String>)queryParams);
        });
    }

    public CompletableFuture<PlatformManagedConnectionDescriptor> getConnectionDescriptor(String connectionUri) throws RequestAuthenticationException {
        LOGGER.debug("Fetching connection descriptor for connection {}", (Object)connectionUri);
        return this.getCoreServicesAccessToken().thenCompose(csToken -> {
            String uri = this.getConnectionDescriptorUrl(connectionUri);
            return this.ocsRequest((String)csToken, uri, HttpConstants.Method.GET).thenApply(response -> {
                InputStream responseBody = response.getEntity().getContent();
                try {
                    BindingContext bindingContext = BindingContext.builder().addBinding("payload", new TypedValue((Object)responseBody, DataType.JSON_STRING)).build();
                    TypedValue descriptor = this.expressionLanguage.evaluate(DESCRIPTOR_MAPPING_EXPRESSION, CONNECTION_DESCRIPTOR_DATA_TYPE, bindingContext);
                    ImmutablePlatformManagedConnectionDescriptor immutablePlatformManagedConnectionDescriptor = new ImmutablePlatformManagedConnectionDescriptor((PlatformManagedConnectionDescriptor)descriptor.getValue());
                    return immutablePlatformManagedConnectionDescriptor;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)responseBody);
                }
            });
        });
    }

    private CompletableFuture<HttpResponse> ocsRequest(String csToken, String uri, HttpConstants.Method method) {
        return this.ocsRequest(csToken, uri, method, null, true);
    }

    private CompletableFuture<HttpResponse> ocsRequest(String csToken, String uri, HttpConstants.Method method, MultiMap<String, String> queryParams) {
        return this.ocsRequest(csToken, uri, method, queryParams, true);
    }

    private CompletableFuture<HttpResponse> ocsRequest(String csToken, String uri, HttpConstants.Method method, MultiMap<String, String> queryParams, boolean refreshOnUnauthorized) {
        return this.httpClient.sendAsync(this.coreServicesRequest(uri, csToken, method, queryParams), OCS_REQUEST_OPTIONS).thenCompose(originalResponse -> {
            int statusCode = originalResponse.getStatusCode();
            if (this.isStatusCodeUnauthorized(statusCode)) {
                if (refreshOnUnauthorized) {
                    LOGGER.info("Anypoint Platform access token expired. Request to {} returned status code {}. Attempting to refresh access token", (Object)uri, (Object)statusCode);
                    return this.refreshCoreServicesAccessToken().thenCompose(refreshedToken -> this.ocsRequest((String)refreshedToken, uri, method, queryParams, false));
                }
                LOGGER.info("Refresh token of Anypoint Platform access token failed with status code {}. Will not retry.", (Object)statusCode);
            } else if (!this.isStatusCodeSuccessful(statusCode)) {
                this.handleOcsError((HttpResponse)originalResponse, statusCode, uri);
            }
            return CompletableFuture.completedFuture(originalResponse);
        });
    }

    String getAccessTokenUrl(String connectionUri) {
        return this.settings.getPlatformUrl() + this.apiPrefix + "/organizations/" + this.settings.getOrganizationId() + "/connections/" + connectionUri + "/token";
    }

    String getRefreshTokenUrl(String connectionUri) {
        return this.settings.getPlatformUrl() + this.apiPrefix + "/organizations/" + this.settings.getOrganizationId() + "/connections/" + connectionUri + "/token";
    }

    String getConnectionDescriptorUrl(String connectionUri) {
        return this.settings.getPlatformUrl() + this.apiPrefix + "/organizations/" + this.settings.getOrganizationId() + "/connections/" + connectionUri;
    }

    private HttpRequest coreServicesRequest(String uri, String csAccessToken, HttpConstants.Method method, MultiMap<String, String> queryParams) {
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder().uri(uri).method(method).addHeader("Authorization", "bearer " + csAccessToken);
        if (queryParams != null) {
            builder.queryParams(queryParams);
        }
        return builder.build();
    }

    private CompletableFuture<String> getCoreServicesAccessToken() throws RequestAuthenticationException {
        this.assertDancerSet();
        return this.dancer.accessToken();
    }

    private CompletableFuture<String> refreshCoreServicesAccessToken() {
        this.assertDancerSet();
        return this.dancer.refreshToken().thenApply(v -> this.dancer.getContext().getAccessToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCoreServicesDancer(LockFactory lockFactory, Map<String, ResourceOwnerOAuthContext> tokenStore, MuleExpressionLanguage expressionLanguage) {
        if (this.dancer != null) {
            return;
        }
        OCSClient oCSClient = this;
        synchronized (oCSClient) {
            if (this.dancer != null) {
                return;
            }
            Preconditions.checkState((this.oauthService != null ? 1 : 0) != 0, (String)"oauthService has not been set");
            try {
                this.dancer = (ClientCredentialsOAuthDancer)this.oauthService.clientCredentialsGrantTypeDancerBuilder(lockFactory, tokenStore, expressionLanguage).name("OCS@" + this.settings.getPlatformUrl()).encoding(this.settings.getEncoding()).clientCredentials(this.settings.getClientId(), this.settings.getClientSecret()).tokenUrl(this.settings.getTokenUrl()).withClientCredentialsIn(this.settings.getClientCredentialsLocation()).build();
                LifecycleUtils.initialiseIfNeeded((Object)this.dancer);
                LifecycleUtils.startIfNeeded((Object)this.dancer);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not obtain access token from Anypoint Platform"), (Throwable)e);
            }
        }
    }

    private boolean isStatusCodeSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean isStatusCodeUnauthorized(int statusCode) {
        return statusCode == HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOcsError(HttpResponse errorResponse, int statusCode, String uri) {
        String errorMessage = null;
        InputStream content = errorResponse.getEntity().getContent();
        try {
            BindingContext bindingContext = BindingContext.builder().addBinding("payload", new TypedValue((Object)content, DataType.JSON_STRING)).build();
            errorMessage = (String)this.expressionLanguage.evaluate("#[payload.message]", DataType.STRING, bindingContext).getValue();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("Failed to retrieve error message from request to %s with status code %d .", uri, statusCode), (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)content);
        }
        if (StringUtils.isBlank(errorMessage)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Got status code %d when trying when making a request to : %s", statusCode, uri)));
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Got status code %d when trying when making a request to : %s . Message : %s", statusCode, uri, errorMessage)));
    }

    private void assertDancerSet() {
        Preconditions.checkState((this.dancer != null ? 1 : 0) != 0, (String)"Core Services Dancer not yet initialized");
    }

    public static class OCSClientFactory {
        public OCSClient create(HttpClient client, OCSSettings settings, ExpressionLanguage expressionLanguage, OAuthService oauthService) {
            return new OCSClient(client, settings, expressionLanguage, oauthService);
        }

        private OCSClientFactory() {
        }
    }
}

