/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.oauth.internal;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.oauth.api.OAuthService;

import javax.inject.Inject;

/**
 * Provides the EE implementation of the {@link OAuthService}
 *
 * @since 1.0
 */
public class EEOAuthServiceProvider implements ServiceProvider {

  @Inject
  private HttpService httpService;

  @Inject
  private SchedulerService schedulerService;

  @Override
  public ServiceDefinition getServiceDefinition() {
    return new ServiceDefinition(OAuthService.class, new EEOAuthService(httpService, schedulerService));
  }
}
