/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.oauth.internal.platform;

import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;

import java.util.Map;

/**
 * Default implementation of {@link PlatformManagedConnectionDescriptor}
 *
 * @since 1.0
 */
public class DefaultPlatformManagedConnectionDescriptor implements PlatformManagedConnectionDescriptor {

  private String id;
  private String displayName;
  private String uri;
  private Map<String, Object> parameters;

  @Override
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Override
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  @Override
  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  @Override
  public Map<String, Object> getParameters() {
    return parameters;
  }

  public void setParameters(Map<String, Object> parameters) {
    this.parameters = parameters;
  }
}
