/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.oauth.internal.platform;

import static java.util.Collections.emptyMap;
import static java.util.Collections.unmodifiableMap;

import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;

import java.util.Map;

/**
 * Immutable implementation of {@link PlatformManagedConnectionDescriptor}
 *
 * @since 1.0
 */
public class ImmutablePlatformManagedConnectionDescriptor implements PlatformManagedConnectionDescriptor {

  private final String id;
  private final String displayName;
  private final String uri;
  private final Map<String, Object> parameters;

  /**
   * Creates a new instance with the same values as the {@code original}
   *
   * @param original a pre existing {@link PlatformManagedConnectionDescriptor} to be copied
   */
  public ImmutablePlatformManagedConnectionDescriptor(PlatformManagedConnectionDescriptor original) {
    this(original.getId(), original.getDisplayName(), original.getUri(), original.getParameters());
  }

  /**
   * Creates a new instance
   *
   * @param id          the connection id
   * @param displayName the connection name
   * @param uri         the connection URI
   * @param parameters  the connection parameter
   */
  public ImmutablePlatformManagedConnectionDescriptor(String id,
                                                      String displayName,
                                                      String uri,
                                                      Map<String, Object> parameters) {
    this.id = id;
    this.displayName = displayName;
    this.uri = uri;
    this.parameters = parameters != null ? unmodifiableMap(parameters) : emptyMap();
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getDisplayName() {
    return displayName;
  }

  @Override
  public String getUri() {
    return uri;
  }

  @Override
  public Map<String, Object> getParameters() {
    return parameters;
  }
}
