/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.oauth.internal.platform.config;

import com.mulesoft.service.oauth.internal.platform.OCSClient;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.internal.config.OAuthDancerConfig;

/**
 *
 * Set of attributes needed to create platform managed dancer
 * {@link com.mulesoft.service.oauth.internal.platform.DefaultPlatformManagedDancer}.
 * 
 * @since 1.1.0
 */
public class DefaultPlatformManagedDancerConfig extends OAuthDancerConfig {

  private String connectionUri;
  private String organizationId;
  private String platformUrl;
  private String apiVersion;
  private OCSClient.OCSClientFactory ocsClientFactory;
  private OAuthService oauthService;

  public String getConnectionUri() {
    return connectionUri;
  }

  public void setConnectionUri(String connectionUri) {
    this.connectionUri = connectionUri;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(String organizationId) {
    this.organizationId = organizationId;
  }

  public String getPlatformUrl() {
    return platformUrl;
  }

  public void setPlatformUrl(String platformUrl) {
    this.platformUrl = platformUrl;
  }

  public String getApiVersion() {
    return apiVersion;
  }

  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }

  public OCSClient.OCSClientFactory getOcsClientFactory() {
    return ocsClientFactory;
  }

  public void setOcsClientFactory(OCSClient.OCSClientFactory ocsClientFactory) {
    this.ocsClientFactory = ocsClientFactory;
  }

  public OAuthService getOauthService() {
    return oauthService;
  }

  public void setOauthService(OAuthService oauthService) {
    this.oauthService = oauthService;
  }
}
