/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.service.oauth.provider;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.oauth.api.OAuthService;

import com.mulesoft.service.oauth.internal.EEOAuthService;

import javax.inject.Inject;

/**
 * Provides the EE implementation of the {@link OAuthService}
 *
 * @since 1.0
 */
public class EEOAuthServiceProvider implements ServiceProvider {

  @Inject
  private HttpService httpService;

  @Inject
  private SchedulerService schedulerService;

  @Override
  public ServiceDefinition getServiceDefinition() {
    return new ServiceDefinition(OAuthService.class, new EEOAuthService(httpService, schedulerService));
  }
}
