/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.EEOAuthService;
import com.mulesoft.service.oauth.internal.platform.DefaultOAuthPlatformManagedDancerBuilder;
import com.mulesoft.service.oauth.internal.platform.DefaultPlatformManagedDancer;
import com.mulesoft.service.oauth.internal.platform.OCSClient;
import com.mulesoft.service.oauth.internal.platform.OCSSettings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.oauth.client.api.builder.ClientCredentialsLocation;
import org.mule.oauth.client.api.builder.OAuthDancerBuilder;
import org.mule.oauth.client.api.exception.TokenNotFoundException;
import org.mule.oauth.client.api.exception.TokenUrlResponseException;
import org.mule.oauth.client.api.http.HttpClientFactory;
import org.mule.oauth.client.api.state.DancerState;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;
import org.mule.service.oauth.internal.DefaultOAuthService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

public class PlatformManagedDancerTestCase
extends AbstractOAuthTestCase {
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String SERVICE_URL = "https://cs.anypoint.com/ocs";
    private static final String AUTH_URL = "https://cs.anypoint.com/token";
    private static final String ORG_ID = "fooOrg";
    private static final String CONNECTION_URI = "ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf";
    private static final String ACCESS_TOKEN = "myToken";
    private static final String REFRESHED_ACCESS_TOKEN = "myToken";
    private static final String REFRESH_TOKEN = "refreshMe";
    private static final String REFRESHED_TOKEN_NEW_REVISION = "2";
    private static final String ANOTHER_API_VERSION = "v2";
    private static final String ACCESS_TOKEN_RESPONSE = "{\n\"access_token\": \"myToken\",\n\"refresh_token\": \"refreshMe\"\n}";
    private static final String REFRESH_TOKEN_RESPONSE = "{\n\"access_token\": \"myToken\",\n\"refresh_token\": \"refreshMe\"\n}";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OCSClient ocsClient;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpResponse accessTokenHttpResponse;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpResponse refreshTokenHttpResponse;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpResponse connectionDescriptorResponse;
    @Mock
    private OCSClient.OCSClientFactory ocsClientFactory;
    @Mock
    private PlatformManagedOAuthStateListener listener;
    @Mock
    private HttpClientFactory httpClientFactory;
    @Mock
    private HttpClient httpClient;
    @Inject
    private MuleExpressionLanguage expressionLanguage;
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private Map<String, ?> tokensStore = new HashMap();
    private OAuthPlatformManagedDancerBuilder builder;
    private DefaultPlatformManagedDancer dancer;
    private SimpleUnitTestSupportSchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
    private DefaultOAuthService service;
    private String revisionToken = "1";

    public void setupServices() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        super.setupServices();
        this.service = new EEOAuthService(this.httpService, (SchedulerService)this.schedulerService);
        this.expressionLanguage = (MuleExpressionLanguage)Mockito.spy((Object)this.expressionLanguage);
        this.mockResponseBody(this.accessTokenHttpResponse, "{\n\"access_token\": \"myToken\",\n\"refresh_token\": \"refreshMe\"\n}", this.revisionToken);
        this.mockResponseBody(this.refreshTokenHttpResponse, "{\n\"access_token\": \"myToken\",\n\"refresh_token\": \"refreshMe\"\n}", REFRESHED_TOKEN_NEW_REVISION);
        Mockito.when((Object)this.ocsClient.getAccessToken(CONNECTION_URI)).thenAnswer(this.delayedResponse(this.accessTokenHttpResponse));
        Mockito.when((Object)this.ocsClient.refreshToken(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(this.delayedResponse(this.refreshTokenHttpResponse));
        Mockito.when((Object)this.ocsClient.getConnectionDescriptor(CONNECTION_URI)).thenAnswer(this.delayedResponse(this.connectionDescriptorResponse));
        Mockito.when((Object)this.ocsClientFactory.create((HttpClient)ArgumentMatchers.same((Object)this.httpClient), (OCSSettings)ArgumentMatchers.any(), (ExpressionLanguage)ArgumentMatchers.same((Object)this.expressionLanguage), (OAuthService)ArgumentMatchers.same((Object)this.service))).thenReturn((Object)this.ocsClient);
        Mockito.when((Object)this.httpClientFactory.create((TlsContextFactory)ArgumentMatchers.any(), (ProxyConfig)ArgumentMatchers.any())).thenReturn((Object)this.httpClient);
        this.builder = this.basePlatformOAuthDancerBuilder(this.tokensStore);
        this.dancer = this.createDancer((OAuthDancerBuilder<PlatformManagedOAuthDancer>)this.builder);
    }

    public void teardownServices() {
        super.teardownServices();
        FunctionalUtils.safely(() -> ((SimpleUnitTestSupportSchedulerService)this.schedulerService).stop());
        ((MuleExpressionLanguage)Mockito.verify((Object)this.expressionLanguage, (VerificationMode)Mockito.never())).evaluate((String)ArgumentMatchers.eq((Object)"#[payload.refresh_token]"), (DataType)ArgumentMatchers.any(), (BindingContext)ArgumentMatchers.any());
        if (this.dancer != null) {
            FunctionalUtils.safely(() -> LifecycleUtils.stopIfNeeded((Object)this.dancer));
            ((HttpClient)Mockito.verify((Object)this.httpClient)).stop();
        }
    }

    @Test
    public void clientPropertyConfigured() {
        ArgumentCaptor settingsCaptor = ArgumentCaptor.forClass(OCSSettings.class);
        ((OCSClient.OCSClientFactory)Mockito.verify((Object)this.ocsClientFactory)).create((HttpClient)ArgumentMatchers.same((Object)this.httpClient), (OCSSettings)settingsCaptor.capture(), (ExpressionLanguage)ArgumentMatchers.same((Object)this.expressionLanguage), (OAuthService)ArgumentMatchers.same((Object)this.service));
        OCSSettings settings = (OCSSettings)settingsCaptor.getValue();
        Assert.assertThat((Object)settings.getPlatformUrl(), (Matcher)Matchers.is((Object)SERVICE_URL));
        Assert.assertThat((Object)settings.getOrganizationId(), (Matcher)Matchers.is((Object)ORG_ID));
        Assert.assertThat((Object)settings.getClientCredentialsLocation(), (Matcher)Matchers.is((Object)ClientCredentialsLocation.BODY));
        Assert.assertThat((Object)settings.getTokenUrl(), (Matcher)Matchers.is((Object)AUTH_URL));
        Assert.assertThat((Object)settings.getEncoding(), (Matcher)Matchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)settings.getClientId(), (Matcher)Matchers.is((Object)CLIENT_ID));
        Assert.assertThat((Object)settings.getClientSecret(), (Matcher)Matchers.is((Object)CLIENT_SECRET));
        Assert.assertThat((Object)settings.getApiVersion(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void clientPropertyConfiguredWithAnApiVersion() throws Exception {
        Mockito.reset((Object[])new OCSClient[]{this.ocsClient});
        this.builder = this.basePlatformOAuthDancerBuilder(this.tokensStore, ANOTHER_API_VERSION);
        this.dancer = this.createDancer((OAuthDancerBuilder<PlatformManagedOAuthDancer>)this.builder);
        ArgumentCaptor settingsCaptor = ArgumentCaptor.forClass(OCSSettings.class);
        ((OCSClient.OCSClientFactory)Mockito.verify((Object)this.ocsClientFactory, (VerificationMode)Mockito.times((int)2))).create((HttpClient)ArgumentMatchers.same((Object)this.httpClient), (OCSSettings)settingsCaptor.capture(), (ExpressionLanguage)ArgumentMatchers.same((Object)this.expressionLanguage), (OAuthService)ArgumentMatchers.same((Object)this.service));
        OCSSettings settings = (OCSSettings)settingsCaptor.getValue();
        Assert.assertThat((Object)settings.getPlatformUrl(), (Matcher)Matchers.is((Object)SERVICE_URL));
        Assert.assertThat((Object)settings.getOrganizationId(), (Matcher)Matchers.is((Object)ORG_ID));
        Assert.assertThat((Object)settings.getClientCredentialsLocation(), (Matcher)Matchers.is((Object)ClientCredentialsLocation.BODY));
        Assert.assertThat((Object)settings.getTokenUrl(), (Matcher)Matchers.is((Object)AUTH_URL));
        Assert.assertThat((Object)settings.getEncoding(), (Matcher)Matchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)settings.getClientId(), (Matcher)Matchers.is((Object)CLIENT_ID));
        Assert.assertThat((Object)settings.getClientSecret(), (Matcher)Matchers.is((Object)CLIENT_SECRET));
        Assert.assertThat((Object)settings.getApiVersion(), (Matcher)Matchers.is((Object)ANOTHER_API_VERSION));
    }

    @Test
    public void accessToken() throws Exception {
        String accessToken = (String)this.dancer.accessToken().get();
        Assert.assertThat((Object)accessToken, (Matcher)Matchers.equalTo((Object)"myToken"));
        ((PlatformManagedOAuthStateListener)Mockito.verify((Object)this.listener)).onAccessToken((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        Assert.assertThat((Object)this.dancer.getRevisionToken(), (Matcher)Matchers.equalTo((Object)this.revisionToken));
    }

    @Test
    public void platformReturnsErrorOnStart() throws Exception {
        Mockito.when((Object)this.accessTokenHttpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode());
        this.expected.expect(LifecycleException.class);
        this.expected.expectCause(Matchers.is((Matcher)Matchers.instanceOf(TokenUrlResponseException.class)));
        Mockito.clearInvocations((Object[])new PlatformManagedOAuthStateListener[]{this.listener});
        try {
            this.dancer = this.createDancer((OAuthDancerBuilder<PlatformManagedOAuthDancer>)this.builder);
        }
        finally {
            ((PlatformManagedOAuthStateListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onAccessToken((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        }
    }

    @Test
    public void platformReturnsNotFoundOnStart() throws Exception {
        Mockito.when((Object)this.accessTokenHttpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode());
        this.expected.expect(LifecycleException.class);
        this.expected.expectCause(Matchers.is((Matcher)Matchers.instanceOf(TokenNotFoundException.class)));
        Mockito.clearInvocations((Object[])new PlatformManagedOAuthStateListener[]{this.listener});
        try {
            this.dancer = this.createDancer((OAuthDancerBuilder<PlatformManagedOAuthDancer>)this.builder);
        }
        finally {
            ((PlatformManagedOAuthStateListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onAccessToken((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        }
    }

    @Test
    public void refreshToken() throws Exception {
        this.dancer.refreshToken().get();
        String accessToken = (String)this.dancer.accessToken().get();
        Assert.assertThat((Object)accessToken, (Matcher)Matchers.equalTo((Object)"myToken"));
        this.assertRefreshTokenListened();
        Assert.assertThat((Object)this.dancer.getRevisionToken(), (Matcher)Matchers.equalTo((Object)REFRESHED_TOKEN_NEW_REVISION));
    }

    @Test
    public void sendCorrectRevisionAfterRefresh() throws Exception {
        this.refreshToken();
        String thirdRevision = "3";
        this.mockResponseBody(this.refreshTokenHttpResponse, "{\n\"access_token\": \"myToken\",\n\"refresh_token\": \"refreshMe\"\n}", "3");
        this.dancer.refreshToken().get();
        ArgumentCaptor revisionCaptor = ArgumentCaptor.forClass(String.class);
        ((OCSClient)Mockito.verify((Object)this.ocsClient, (VerificationMode)Mockito.times((int)2))).refreshToken(ArgumentMatchers.anyString(), (String)revisionCaptor.capture());
        Assert.assertThat((Object)((String)revisionCaptor.getValue()), (Matcher)Matchers.equalTo((Object)REFRESHED_TOKEN_NEW_REVISION));
        Assert.assertThat((Object)this.dancer.getRevisionToken(), (Matcher)Matchers.equalTo((Object)"3"));
    }

    @Test
    public void refreshTokenDoesntProvideNewRevision() throws Exception {
        this.mockResponseBody(this.refreshTokenHttpResponse, "{\n\"access_token\": \"myToken\",\n\"refresh_token\": \"refreshMe\"\n}", null);
        this.dancer.refreshToken().get();
        String accessToken = (String)this.dancer.accessToken().get();
        Assert.assertThat((Object)accessToken, (Matcher)Matchers.equalTo((Object)"myToken"));
        this.assertRefreshTokenListened();
        Assert.assertThat((Object)this.dancer.getRevisionToken(), (Matcher)Matchers.equalTo((Object)this.revisionToken));
    }

    @Test
    public void platformReturnsErrorOnRefreshToken() throws Exception {
        Mockito.when((Object)this.refreshTokenHttpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode());
        this.expected.expect(ExecutionException.class);
        this.expected.expectCause(Matchers.is((Matcher)Matchers.instanceOf(TokenUrlResponseException.class)));
        try {
            this.dancer.refreshToken().get();
        }
        finally {
            ((PlatformManagedOAuthStateListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        }
    }

    @Test
    public void platformReturnsNotFoundOnRefreshToken() throws Exception {
        Mockito.when((Object)this.refreshTokenHttpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode());
        this.expected.expect(ExecutionException.class);
        this.expected.expectCause(Matchers.is((Matcher)Matchers.instanceOf(TokenNotFoundException.class)));
        try {
            this.dancer.refreshToken().get();
        }
        finally {
            ((PlatformManagedOAuthStateListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        }
    }

    @Test
    public void refetchAccessTokenAfterInvalidate() throws Exception {
        Assert.assertThat((Object)((String)this.dancer.accessToken().get()), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        this.dancer.invalidateContext();
        Mockito.clearInvocations((Object[])new PlatformManagedOAuthStateListener[]{this.listener});
        Assert.assertThat((Object)((String)this.dancer.accessToken().get()), (Matcher)Matchers.equalTo((Object)"myToken"));
        this.assertAccessTokenListened("myToken");
        ((OCSClient)Mockito.verify((Object)this.ocsClient, (VerificationMode)Mockito.times((int)2))).getAccessToken(CONNECTION_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenOnceAtATime() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        this.tokensStore.clear();
        try {
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                futures.add(executor.submit(() -> {
                    try {
                        this.dancer.refreshToken().get();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }));
            }
            for (Future future : futures) {
                future.get(50000L, TimeUnit.MILLISECONDS);
            }
            ((OCSClient)Mockito.verify((Object)this.ocsClient)).refreshToken(CONNECTION_URI, this.revisionToken);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void refreshTokenOnceAtATimeSequential() throws Exception {
        CompletableFuture refreshToken1 = this.dancer.refreshToken();
        CompletableFuture refreshToken2 = this.dancer.refreshToken();
        refreshToken1.get();
        refreshToken2.get();
        ((OCSClient)Mockito.verify((Object)this.ocsClient)).refreshToken(CONNECTION_URI, this.revisionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionOnTokenRequest() throws Exception {
        IllegalStateException thrown = new IllegalStateException();
        Mockito.when((Object)this.ocsClient.getAccessToken(CONNECTION_URI)).thenThrow(new Throwable[]{thrown});
        HashMap tokensStore = new HashMap();
        OAuthPlatformManagedDancerBuilder builder = this.basePlatformOAuthDancerBuilder(tokensStore);
        this.expected.expect(Matchers.sameInstance((Object)thrown));
        try {
            this.createDancer((OAuthDancerBuilder<PlatformManagedOAuthDancer>)builder);
        }
        finally {
            Assert.assertThat((Object)((ResourceOwnerOAuthContextWithRefreshState)tokensStore.get("default")).getDancerState(), (Matcher)Matchers.is((Object)DancerState.NO_TOKEN));
        }
    }

    @Test
    public void invalidateContext() {
        Assert.assertThat((Object)this.tokensStore.size(), (Matcher)Matchers.is((Object)1));
        this.dancer.invalidateContext();
        Assert.assertThat((Object)this.tokensStore.size(), (Matcher)Matchers.is((Object)0));
        ResourceOwnerOAuthContext context = this.dancer.getContext();
        Assert.assertThat((Object)context.getAccessToken(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)context.getRefreshToken(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        ((PlatformManagedOAuthStateListener)Mockito.verify((Object)this.listener)).onTokenInvalidated();
    }

    @Test
    public void addListener() throws Exception {
        PlatformManagedOAuthStateListener addedListener = (PlatformManagedOAuthStateListener)Mockito.mock(PlatformManagedOAuthStateListener.class);
        this.dancer.addListener(addedListener);
        this.invalidateContext();
        ((PlatformManagedOAuthStateListener)Mockito.verify((Object)addedListener)).onTokenInvalidated();
        Mockito.clearInvocations((Object[])new PlatformManagedOAuthStateListener[]{this.listener});
        this.accessToken();
        this.assertAccessTokenListened("myToken", addedListener);
        this.refreshToken();
        this.assertRefreshTokenListened(addedListener);
    }

    @Test
    public void getConnectionDescriptor() throws Exception {
        PlatformManagedConnectionDescriptor descriptor = (PlatformManagedConnectionDescriptor)Mockito.mock(PlatformManagedConnectionDescriptor.class);
        Mockito.when((Object)this.ocsClient.getConnectionDescriptor(CONNECTION_URI)).thenReturn(CompletableFuture.completedFuture(descriptor));
        Assert.assertThat((Object)((PlatformManagedConnectionDescriptor)this.dancer.getConnectionDescriptor().get()), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)descriptor)));
    }

    @Test
    public void removeListener() throws Exception {
        this.dancer.removeListener(this.listener);
        Mockito.clearInvocations((Object[])new PlatformManagedOAuthStateListener[]{this.listener});
        this.dancer.invalidateContext();
        this.dancer.accessToken().get();
        this.dancer.refreshToken().get();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    private void mockResponseBody(HttpResponse response, String body, String revisionToken) {
        Mockito.reset((Object[])new HttpResponse[]{response});
        Mockito.when((Object)response.getEntity()).thenAnswer(inv -> new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(body.getBytes())));
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.OK.getStatusCode());
        Mockito.when((Object)response.getHeaderValue("Content-Type")).thenReturn((Object)MediaType.APPLICATION_JSON.toRfcString());
        Mockito.when((Object)response.getHeaderValue("x-revisionToken")).thenReturn((Object)revisionToken);
    }

    private Answer<?> delayedResponse(HttpResponse response) {
        return inv -> {
            CompletableFuture responseFuture = new CompletableFuture();
            this.httpClientCallbackExecutor.execute(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    responseFuture.completeExceptionally(e);
                }
                responseFuture.complete(response);
            });
            return responseFuture;
        };
    }

    protected OAuthPlatformManagedDancerBuilder basePlatformOAuthDancerBuilder(Map<String, ?> tokensStore) {
        return this.basePlatformOAuthDancerBuilder(tokensStore, null);
    }

    protected OAuthPlatformManagedDancerBuilder basePlatformOAuthDancerBuilder(Map<String, ?> tokensStore, String apiVersion) {
        DefaultOAuthPlatformManagedDancerBuilder builder = new DefaultOAuthPlatformManagedDancerBuilder((OAuthService)this.service, this.ocsClientFactory, (SchedulerService)this.schedulerService, this.lockFactory, tokensStore, this.httpClientFactory, this.expressionLanguage);
        this.service.platformManagedOAuthDancerBuilder(this.lockFactory, tokensStore, this.expressionLanguage);
        builder.connectionUri(CONNECTION_URI).platformUrl(SERVICE_URL).organizationId(ORG_ID).apiVersion(apiVersion).addListener(this.listener).tokenUrl(AUTH_URL).withClientCredentialsIn(ClientCredentialsLocation.BODY).encoding(StandardCharsets.UTF_8).clientCredentials(CLIENT_ID, CLIENT_SECRET);
        return builder;
    }

    private DefaultPlatformManagedDancer createDancer(OAuthDancerBuilder<PlatformManagedOAuthDancer> builder) throws MuleException {
        try {
            DefaultPlatformManagedDancer dancer = (DefaultPlatformManagedDancer)this.startDancer(builder);
            ((OCSClient)Mockito.verify((Object)this.ocsClient)).getAccessToken(CONNECTION_URI);
            this.assertAccessTokenListened("myToken");
            return dancer;
        }
        catch (MuleException e) {
            this.dancer = null;
            throw e;
        }
    }

    private void assertAccessTokenListened(String accessToken) {
        this.assertAccessTokenListened(accessToken, this.listener);
    }

    private void assertAccessTokenListened(String accessToken, PlatformManagedOAuthStateListener listener) {
        ArgumentCaptor listenerContextCaptor = ArgumentCaptor.forClass(ResourceOwnerOAuthContext.class);
        ((PlatformManagedOAuthStateListener)Mockito.verify((Object)listener)).onAccessToken((ResourceOwnerOAuthContext)listenerContextCaptor.capture());
        ResourceOwnerOAuthContext listenerContext = (ResourceOwnerOAuthContext)listenerContextCaptor.getValue();
        Assert.assertThat((Object)listenerContext.getAccessToken(), (Matcher)Matchers.equalTo((Object)accessToken));
        Assert.assertThat((Object)listenerContext.getRefreshToken(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private void assertRefreshTokenListened() {
        this.assertRefreshTokenListened(this.listener);
    }

    private void assertRefreshTokenListened(PlatformManagedOAuthStateListener listener) {
        ArgumentCaptor listenerContextCaptor = ArgumentCaptor.forClass(ResourceOwnerOAuthContext.class);
        ((PlatformManagedOAuthStateListener)Mockito.verify((Object)listener)).onTokenRefreshed((ResourceOwnerOAuthContext)listenerContextCaptor.capture());
        ResourceOwnerOAuthContext listenerContext = (ResourceOwnerOAuthContext)listenerContextCaptor.getValue();
        Assert.assertThat((Object)listenerContext.getAccessToken(), (Matcher)Matchers.equalTo((Object)"myToken"));
        Assert.assertThat((Object)listenerContext.getRefreshToken(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

