/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */

import org.mule.api.annotation.jpms.ServiceModule;

/**
 * Provides OAuth authentication services.
 *
 * @moduleGraph
 * @since 1.2
 */
@ServiceModule
module com.mulesoft.mule.service.oauth.ee {

  requires transitive org.mule.service.oauth;

  requires org.mule.oauth.client.api;
  requires org.mule.oauth.client.impl;
  requires org.mule.runtime.oauth.api;
  requires org.mule.runtime.http.api;
  // lifecycle api
  requires org.mule.runtime.core;

  requires java.inject;

  requires org.apache.commons.lang3;

  // Allow invocation and injection into providers by the Mule Runtime
  exports com.mulesoft.service.oauth.provider to
      org.mule.runtime.service;
  opens com.mulesoft.service.oauth.provider to
      org.mule.runtime.service;
  exports com.mulesoft.service.oauth.internal to
    com.mulesoft.test.mule.service.oauth.ee;
  exports com.mulesoft.service.oauth.internal.platform to
    com.mulesoft.test.mule.service.oauth.ee;
}
