/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.platform.OCSClient;
import com.mulesoft.service.oauth.internal.platform.OCSSettings;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.builder.ClientCredentialsLocation;
import org.mule.oauth.client.api.builder.OAuthDancerBuilder;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;

public class OCSClientTestCase
extends AbstractOAuthTestCase {
    private static final String SERVICE_URL = "https://cs.anypoint.com/ocs";
    private static final String AUTH_URL = "https://cs.anypoint.com/token";
    private static final String CLIENT_ID = "ocsClient";
    private static final String CLIENT_SECRET = "ocsSecret";
    private static final String ORG_ID = "fooOrg";
    private static final String ANOTHER_API_VERSION = "v80";
    private static final String CONNECTION_ID = UUID.randomUUID().toString();
    private static final String CONNECTION_NAME = "My Connection";
    private static final String CONNECTION_URI = "ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf";
    private static final String FULLNAME_PARAMETER = "Bond... James Bond";
    private static final String AGE_PARAMETER = "33";
    private static final String REQUEST_METHOD = "GET";
    private static final String REQUEST_PATH = "/test";
    private static final String NUMBER = "1";
    private static final int THREAD_COUNT = 5;
    private static final String PLATFORM_ACCESS_TOKEN = "coreServicesToken";
    private static final String REFRESHED_PLATFORM_ACCESS_TOKEN = "refreshed-coreServicesToken";
    private static final String API_VERSION = "v1";
    private static final String API_PREFIX = "/api/v1";
    private static final String CONNECTION_DESCRIPTOR_RESPONSE = String.format("{\n   \"id\":\"%s\",\n   \"displayName\":\"%s\",\n   \"uri\":\"%s\",\n   \"parameters\":{\n      \"fullname\":\"%s\",\n      \"age\":\"%s\",\n      \"connectivityTest\":{\n         \"requestMethod\":\"GET\",\n         \"requestPath\":\"/test\"\n      },\n      \"someConnectivityTests\":[\n         {\n            \"requestMethod\":\"GET\",\n            \"requestPath\":\"/test\"\n         },\n         {\n            \"requestMethod\":\"GET\",\n            \"requestPath\":\"/test\"\n         },\n         {\n            \"requestMethod\":\"GET\",\n            \"requestPath\":\"/test\"\n         }\n      ],\n      \"someNumbers\":[\n         \"1\",\n         \"1\",\n         \"1\"\n      ]\n   }\n}", CONNECTION_ID, "My Connection", "ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf", "Bond... James Bond", "33");
    private static final String CONNECTION_DESCRIPTOR_RESPONSE_WITH_EXTRA_DATA = String.format("{\n   \"id\":\"%s\",\n   \"displayName\":\"%s\",\n   \"uri\":\"%s\",\n   \"extraParameter\":\"extraParameterValue\",\n   \"parameters\":{\n      \"fullname\":\"%s\",\n      \"age\":\"%s\",\n      \"connectivityTest\":{\n         \"requestMethod\":\"GET\",\n         \"requestPath\":\"/test\"\n      },\n      \"someConnectivityTests\":[\n         {\n            \"requestMethod\":\"GET\",\n            \"requestPath\":\"/test\"\n         },\n         {\n            \"requestMethod\":\"GET\",\n            \"requestPath\":\"/test\"\n         },\n         {\n            \"requestMethod\":\"GET\",\n            \"requestPath\":\"/test\"\n         }\n      ],\n      \"someNumbers\":[\n         \"1\",\n         \"1\",\n         \"1\"\n      ]\n   }\n}", CONNECTION_ID, "My Connection", "ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf", "Bond... James Bond", "33");
    private static final String OCS_ERROR_MESSAGE = "OCS Error message";
    private static final String ERROR_RESPONSE_WITH_MESSAGE = "{\n\"message\": \" OCS Error message\",\n\"serviceProviderResponse\": {\n\"errorMessage\": \"The call failed!\",\n\"code\": \"U12380\"\n}\n}";
    private static final String ERROR_RESPONSE_WITHOUT_MESSAGE = "{\n\"serviceProviderResponse\": {\n\"errorMessage\": \"The call failed!\",\n\"code\": \"U12380\"\n}\n}";
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private HttpClient httpClient;
    @Mock
    private LockFactory lockFactory;
    @Mock
    private OAuthService oauthService;
    @Mock(extraInterfaces={Initialisable.class, Startable.class})
    private ClientCredentialsOAuthDancer ccDancer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpResponse httpResponse;
    @Mock
    private ResourceOwnerOAuthContext resourceOwnerOAuthContext;
    @Inject
    private MuleExpressionLanguage expressionLanguage;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private OAuthClientCredentialsDancerBuilder ccDancerBuilder;
    private final Map<String, ResourceOwnerOAuthContext> tokenStore = new ConcurrentHashMap<String, ResourceOwnerOAuthContext>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(5);
    private OCSClient ocsClient;
    private final Reference<String> refreshedToken = new Reference();
    private OCSSettings settings;

    public void setupServices() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        super.setupServices();
        this.expressionLanguage = (MuleExpressionLanguage)Mockito.spy((Object)this.expressionLanguage);
        this.settings = new OCSSettings(SERVICE_URL, AUTH_URL, CLIENT_ID, CLIENT_SECRET, StandardCharsets.UTF_8, ClientCredentialsLocation.BODY, ORG_ID);
        this.ccDancerBuilder = (OAuthClientCredentialsDancerBuilder)Mockito.mock(OAuthClientCredentialsDancerBuilder.class, invocation -> {
            if (invocation.getMethod().getName().equals("build")) {
                return this.ccDancer;
            }
            if (OAuthDancerBuilder.class.isAssignableFrom(invocation.getMethod().getReturnType())) {
                return this.ccDancerBuilder;
            }
            return null;
        });
        Mockito.when((Object)this.oauthService.clientCredentialsGrantTypeDancerBuilder(this.lockFactory, this.tokenStore, this.expressionLanguage)).thenReturn((Object)this.ccDancerBuilder);
        Mockito.when((Object)this.ccDancer.accessToken()).thenReturn(CompletableFuture.completedFuture(PLATFORM_ACCESS_TOKEN));
        Mockito.when((Object)this.ccDancer.refreshToken()).thenAnswer(inv -> {
            this.refreshedToken.set((Object)REFRESHED_PLATFORM_ACCESS_TOKEN);
            return CompletableFuture.completedFuture(null);
        });
        Mockito.when((Object)this.ccDancer.getContext()).thenReturn((Object)this.resourceOwnerOAuthContext);
        this.ocsClient = OCSClient.getFactory().create(this.httpClient, this.settings, (ExpressionLanguage)this.expressionLanguage, this.oauthService);
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(this.httpResponse));
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)200);
    }

    public void teardownServices() {
        try {
            this.executorService.shutdown();
            ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).stop();
            this.ocsClient.stop();
            ((HttpClient)Mockito.verify((Object)this.httpClient)).stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void getAccessTokenUrl() {
        String expected = "https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token";
        Assert.assertThat((Object)this.ocsClient.getAccessTokenUrl(CONNECTION_URI), (Matcher)CoreMatchers.equalTo((Object)"https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token"));
        this.settings = new OCSSettings("https://cs.anypoint.com/ocs/", AUTH_URL, CLIENT_ID, CLIENT_SECRET, StandardCharsets.UTF_8, ClientCredentialsLocation.BODY, ORG_ID);
        this.ocsClient = OCSClient.getFactory().create(this.httpClient, this.settings, (ExpressionLanguage)this.expressionLanguage, this.oauthService);
        Assert.assertThat((Object)this.ocsClient.getAccessTokenUrl(CONNECTION_URI), (Matcher)CoreMatchers.equalTo((Object)"https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token"));
    }

    @Test
    public void getRefreshTokenUrl() {
        String expected = "https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token";
        Assert.assertThat((Object)this.ocsClient.getRefreshTokenUrl(CONNECTION_URI), (Matcher)CoreMatchers.equalTo((Object)"https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token"));
        this.settings = new OCSSettings("https://cs.anypoint.com/ocs/", AUTH_URL, CLIENT_ID, CLIENT_SECRET, StandardCharsets.UTF_8, ClientCredentialsLocation.BODY, ORG_ID);
        this.ocsClient = OCSClient.getFactory().create(this.httpClient, this.settings, (ExpressionLanguage)this.expressionLanguage, this.oauthService);
        Assert.assertThat((Object)this.ocsClient.getRefreshTokenUrl(CONNECTION_URI), (Matcher)CoreMatchers.equalTo((Object)"https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token"));
    }

    @Test
    public void getAccessTokenUrlWithCustomApiVersion() {
        String expected = "https://cs.anypoint.com/ocs/api/v80/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token";
        this.settings = new OCSSettings("https://cs.anypoint.com/ocs/", AUTH_URL, CLIENT_ID, CLIENT_SECRET, StandardCharsets.UTF_8, ClientCredentialsLocation.BODY, ORG_ID, ANOTHER_API_VERSION);
        this.ocsClient = OCSClient.getFactory().create(this.httpClient, this.settings, (ExpressionLanguage)this.expressionLanguage, this.oauthService);
        Assert.assertThat((Object)this.ocsClient.getAccessTokenUrl(CONNECTION_URI), (Matcher)CoreMatchers.equalTo((Object)"https://cs.anypoint.com/ocs/api/v80/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token"));
    }

    @Test
    public void getRefreshTokenUrlWithCustomApiVersion() {
        String expected = "https://cs.anypoint.com/ocs/api/v80/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token";
        this.settings = new OCSSettings("https://cs.anypoint.com/ocs/", AUTH_URL, CLIENT_ID, CLIENT_SECRET, StandardCharsets.UTF_8, ClientCredentialsLocation.BODY, ORG_ID, ANOTHER_API_VERSION);
        this.ocsClient = OCSClient.getFactory().create(this.httpClient, this.settings, (ExpressionLanguage)this.expressionLanguage, this.oauthService);
        Assert.assertThat((Object)this.ocsClient.getRefreshTokenUrl(CONNECTION_URI), (Matcher)CoreMatchers.equalTo((Object)"https://cs.anypoint.com/ocs/api/v80/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token"));
    }

    @Test
    public void initCSDancer() throws Exception {
        this.initCSDancer(1);
    }

    @Test
    public void initCSDancerTwice() throws Exception {
        this.initCSDancer(2);
    }

    @Test
    public void failureToInitCSDancer() throws Exception {
        DefaultMuleException e = new DefaultMuleException("");
        ((Startable)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)((Startable)this.ccDancer))).start();
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        this.initCSDancer(1);
    }

    @Test
    public void initCSDancerConcurrently() throws Exception {
        Latch mainLatch = new Latch();
        CountDownLatch taskLatch = new CountDownLatch(5);
        CountDownLatch finishLatch = new CountDownLatch(5);
        List exceptions = Collections.synchronizedList(new ArrayList(5));
        for (int i = 0; i < 5; ++i) {
            this.executorService.submit(() -> {
                taskLatch.countDown();
                try {
                    mainLatch.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    finishLatch.countDown();
                }
            });
        }
        taskLatch.await();
        mainLatch.release();
        finishLatch.await(30L, TimeUnit.SECONDS);
        Assert.assertThat((Object)exceptions.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        this.verifyCsDancerInitialization();
    }

    @Test
    public void getAccessToken() throws Exception {
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        HttpResponse response = (HttpResponse)this.ocsClient.getAccessToken(CONNECTION_URI).get();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.httpResponse)));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(HttpRequestOptions.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)optionsCaptor.capture());
        HttpRequest request = (HttpRequest)requestCaptor.getValue();
        HttpRequestOptions options = (HttpRequestOptions)optionsCaptor.getValue();
        Assert.assertThat((Object)request.getHeaderValue("Authorization"), (Matcher)CoreMatchers.equalTo((Object)"bearer coreServicesToken"));
        Assert.assertThat((Object)request.getUri().toString(), (Matcher)CoreMatchers.equalTo((Object)this.ocsClient.getAccessTokenUrl(CONNECTION_URI)));
        Assert.assertThat((Object)request.getMethod(), (Matcher)CoreMatchers.equalTo((Object)REQUEST_METHOD));
        Assert.assertThat((Object)options.getResponseTimeout(), (Matcher)CoreMatchers.equalTo((Object)60000));
    }

    @Test
    public void getAccessTokenWithExceptionFromCCDancer() throws Exception {
        Exception e = new Exception();
        Mockito.when((Object)this.ccDancer.accessToken()).thenReturn((Object)ConcurrencyUtils.exceptionallyCompleted((Throwable)e));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        this.ocsClient.getAccessToken(CONNECTION_URI).get();
    }

    @Test
    public void httpClientThrowsExceptionGettingAccessToken() throws Exception {
        RuntimeException e = new RuntimeException();
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        this.ocsClient.getAccessToken(CONNECTION_URI).get();
    }

    @Test
    public void getAccessTokenWithoutInitDancer() throws Exception {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Core Services Dancer not yet initialized");
        this.ocsClient.getAccessToken(CONNECTION_URI);
    }

    @Test
    public void getAccessTokenWithExpiredCSToken() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.OK.getStatusCode());
        Mockito.when((Object)this.resourceOwnerOAuthContext.getAccessToken()).thenAnswer(inv -> this.refreshedToken.get());
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        HttpResponse response = (HttpResponse)this.ocsClient.getAccessToken(CONNECTION_URI).get();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.httpResponse)));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(HttpRequestOptions.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.httpClient, this.ccDancer, this.resourceOwnerOAuthContext});
        ((HttpClient)inOrder.verify((Object)this.httpClient)).sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any());
        ((ClientCredentialsOAuthDancer)inOrder.verify((Object)this.ccDancer)).refreshToken();
        ((ResourceOwnerOAuthContext)inOrder.verify((Object)this.resourceOwnerOAuthContext)).getAccessToken();
        ((HttpClient)inOrder.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)optionsCaptor.capture());
        HttpRequest request = (HttpRequest)requestCaptor.getValue();
        HttpRequestOptions options = (HttpRequestOptions)optionsCaptor.getValue();
        Assert.assertThat((Object)request.getHeaderValue("Authorization"), (Matcher)CoreMatchers.equalTo((Object)"bearer refreshed-coreServicesToken"));
        Assert.assertThat((Object)request.getUri().toString(), (Matcher)CoreMatchers.equalTo((Object)this.ocsClient.getAccessTokenUrl(CONNECTION_URI)));
        Assert.assertThat((Object)request.getMethod(), (Matcher)CoreMatchers.equalTo((Object)REQUEST_METHOD));
        Assert.assertThat((Object)options.getResponseTimeout(), (Matcher)CoreMatchers.equalTo((Object)60000));
    }

    @Test
    public void getAccessTokenWithExpiredCSTokenAndFailToRefresh() throws Exception {
        Exception refreshException = new Exception();
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.OK.getStatusCode());
        Mockito.when((Object)this.ccDancer.refreshToken()).thenReturn((Object)ConcurrencyUtils.exceptionallyCompleted((Throwable)refreshException));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        try {
            this.ocsClient.getAccessToken(CONNECTION_URI).get();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)refreshException)));
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.httpClient, this.ccDancer});
            ((HttpClient)inOrder.verify((Object)this.httpClient)).sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any());
            ((ClientCredentialsOAuthDancer)inOrder.verify((Object)this.ccDancer)).refreshToken();
        }
    }

    @Test
    public void getAccessTokenReturnsBadStatusCode() throws Exception {
        this.expectedException.expectMessage(OCS_ERROR_MESSAGE);
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.FORBIDDEN.getStatusCode());
        Mockito.when((Object)this.httpResponse.getEntity().getContent()).thenAnswer(inv -> new ByteArrayInputStream(ERROR_RESPONSE_WITH_MESSAGE.getBytes()));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.ocsClient.getAccessToken(CONNECTION_URI).get();
    }

    @Test
    public void getAccessTokenReturnsBadStatusCodeAndOcsReturnsNoMessage() throws Exception {
        this.expectedException.expectMessage("Got status code 403 when trying when making a request to : https://cs.anypoint.com/ocs/api/v1/organizations/fooOrg/connections/ocs:123122-123123123121-934834394/instagram/soylamorza-2fun4o3wf/token");
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.FORBIDDEN.getStatusCode());
        Mockito.when((Object)this.httpResponse.getEntity().getContent()).thenAnswer(inv -> new ByteArrayInputStream(ERROR_RESPONSE_WITHOUT_MESSAGE.getBytes()));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.ocsClient.getAccessToken(CONNECTION_URI).get();
    }

    @Test
    public void refreshToken() throws Exception {
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        String revisionToken = NUMBER;
        HttpResponse response = (HttpResponse)this.ocsClient.refreshToken(CONNECTION_URI, NUMBER).get();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.httpResponse)));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(HttpRequestOptions.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)optionsCaptor.capture());
        HttpRequest request = (HttpRequest)requestCaptor.getValue();
        HttpRequestOptions options = (HttpRequestOptions)optionsCaptor.getValue();
        Assert.assertThat((Object)request.getHeaderValue("Authorization"), (Matcher)CoreMatchers.equalTo((Object)"bearer coreServicesToken"));
        Assert.assertThat((Object)request.getUri().toString(), (Matcher)CoreMatchers.equalTo((Object)this.ocsClient.getRefreshTokenUrl(CONNECTION_URI)));
        Assert.assertThat((Object)request.getMethod(), (Matcher)CoreMatchers.equalTo((Object)"POST"));
        Assert.assertThat((Object)((String)request.getQueryParams().get((Object)"rev")), (Matcher)CoreMatchers.equalTo((Object)NUMBER));
        Assert.assertThat((Object)options.getResponseTimeout(), (Matcher)CoreMatchers.equalTo((Object)60000));
    }

    @Test
    public void refreshTokenWithExceptionFromCCDancer() throws Exception {
        Exception e = new Exception();
        Mockito.when((Object)this.ccDancer.accessToken()).thenReturn((Object)ConcurrencyUtils.exceptionallyCompleted((Throwable)e));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        this.ocsClient.refreshToken(CONNECTION_URI, "").get();
    }

    @Test
    public void httpClientThrowsExceptionRefreshingToken() throws Exception {
        RuntimeException e = new RuntimeException();
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        this.ocsClient.refreshToken(CONNECTION_URI, "").get();
    }

    @Test
    public void refreshTokenWithoutInitDancer() throws Exception {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Core Services Dancer not yet initialized");
        this.ocsClient.refreshToken(CONNECTION_URI, "");
    }

    @Test
    public void refreshTokenWithExpiredCSToken() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.OK.getStatusCode());
        Mockito.when((Object)this.resourceOwnerOAuthContext.getAccessToken()).thenAnswer(inv -> this.refreshedToken.get());
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        HttpResponse response = (HttpResponse)this.ocsClient.refreshToken(CONNECTION_URI, "").get();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.httpResponse)));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(HttpRequestOptions.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.httpClient, this.ccDancer, this.resourceOwnerOAuthContext});
        ((HttpClient)inOrder.verify((Object)this.httpClient)).sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any());
        ((ClientCredentialsOAuthDancer)inOrder.verify((Object)this.ccDancer)).refreshToken();
        ((ResourceOwnerOAuthContext)inOrder.verify((Object)this.resourceOwnerOAuthContext)).getAccessToken();
        ((HttpClient)inOrder.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)optionsCaptor.capture());
        HttpRequest request = (HttpRequest)requestCaptor.getValue();
        HttpRequestOptions options = (HttpRequestOptions)optionsCaptor.getValue();
        Assert.assertThat((Object)request.getHeaderValue("Authorization"), (Matcher)CoreMatchers.equalTo((Object)"bearer refreshed-coreServicesToken"));
        Assert.assertThat((Object)request.getUri().toString(), (Matcher)CoreMatchers.equalTo((Object)this.ocsClient.getRefreshTokenUrl(CONNECTION_URI)));
        Assert.assertThat((Object)request.getMethod(), (Matcher)CoreMatchers.equalTo((Object)"POST"));
        Assert.assertThat((Object)options.getResponseTimeout(), (Matcher)CoreMatchers.equalTo((Object)60000));
    }

    @Test
    public void refreshTokenWithExpiredCSTokenAndFailToRefresh() throws Exception {
        Exception refreshException = new Exception();
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.OK.getStatusCode());
        Mockito.when((Object)this.ccDancer.refreshToken()).thenReturn((Object)ConcurrencyUtils.exceptionallyCompleted((Throwable)refreshException));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        try {
            this.ocsClient.refreshToken(CONNECTION_URI, "").get();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)refreshException)));
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.httpClient, this.ccDancer});
            ((HttpClient)inOrder.verify((Object)this.httpClient)).sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any());
            ((ClientCredentialsOAuthDancer)inOrder.verify((Object)this.ccDancer)).refreshToken();
        }
    }

    @Test
    public void refreshTokenReturnsBadStatusCode() throws Exception {
        this.expectedException.expectMessage(OCS_ERROR_MESSAGE);
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.FORBIDDEN.getStatusCode());
        Mockito.when((Object)this.httpResponse.getEntity().getContent()).thenAnswer(inv -> new ByteArrayInputStream(ERROR_RESPONSE_WITH_MESSAGE.getBytes()));
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        this.ocsClient.refreshToken(CONNECTION_URI, "").get();
    }

    private void initCSDancer(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        }
        this.verifyCsDancerInitialization();
    }

    @Test
    public void getConnectionDescriptor() throws Exception {
        this.assertGetConnectionDescriptor(CONNECTION_DESCRIPTOR_RESPONSE);
    }

    @Test
    public void getConnectionDescriptorWithExtraData() throws Exception {
        this.assertGetConnectionDescriptor(CONNECTION_DESCRIPTOR_RESPONSE_WITH_EXTRA_DATA);
    }

    @Test
    public void getConnectionDescriptorWithInvalidStatusCode() throws Exception {
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode());
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(MuleRuntimeException.class));
        this.ocsClient.getConnectionDescriptor(CONNECTION_URI).get();
    }

    private void verifyCsDancerInitialization() throws MuleException {
        ((OAuthClientCredentialsDancerBuilder)Mockito.verify((Object)this.ccDancerBuilder)).name("OCS@https://cs.anypoint.com/ocs");
        ((OAuthClientCredentialsDancerBuilder)Mockito.verify((Object)this.ccDancerBuilder)).encoding(StandardCharsets.UTF_8);
        ((OAuthClientCredentialsDancerBuilder)Mockito.verify((Object)this.ccDancerBuilder)).clientCredentials(CLIENT_ID, CLIENT_SECRET);
        ((OAuthClientCredentialsDancerBuilder)Mockito.verify((Object)this.ccDancerBuilder)).tokenUrl(AUTH_URL);
        ((OAuthClientCredentialsDancerBuilder)Mockito.verify((Object)this.ccDancerBuilder)).withClientCredentialsIn(ClientCredentialsLocation.BODY);
        ((OAuthClientCredentialsDancerBuilder)Mockito.verify((Object)this.ccDancerBuilder)).build();
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.ccDancer))).initialise();
        ((Startable)Mockito.verify((Object)((Startable)this.ccDancer))).start();
    }

    private void assertGetConnectionDescriptor(String getConnectionDescriptorResponse) throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusCode()).thenReturn((Object)HttpConstants.HttpStatus.OK.getStatusCode());
        Mockito.when((Object)this.httpResponse.getEntity().getContent()).thenReturn((Object)new ByteArrayInputStream(getConnectionDescriptorResponse.getBytes()));
        Mockito.when((Object)this.httpResponse.getHeaderValue("Content-Type")).thenReturn((Object)MediaType.APPLICATION_JSON.toRfcString());
        this.ocsClient.initCoreServicesDancer(this.lockFactory, this.tokenStore, this.expressionLanguage);
        PlatformManagedConnectionDescriptor descriptor = (PlatformManagedConnectionDescriptor)this.ocsClient.getConnectionDescriptor(CONNECTION_URI).get();
        Assert.assertThat((Object)descriptor.getId(), (Matcher)CoreMatchers.equalTo((Object)CONNECTION_ID));
        Assert.assertThat((Object)descriptor.getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)CONNECTION_NAME));
        Assert.assertThat((Object)descriptor.getUri(), (Matcher)CoreMatchers.equalTo((Object)CONNECTION_URI));
        Map params = descriptor.getParameters();
        Assert.assertThat((Object)params, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)params.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat(params.get("fullname"), (Matcher)CoreMatchers.equalTo((Object)FULLNAME_PARAMETER));
        Assert.assertThat(params.get("age"), (Matcher)CoreMatchers.equalTo((Object)AGE_PARAMETER));
        Map connectivityTest = (Map)params.get("connectivityTest");
        Assert.assertThat(connectivityTest.keySet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((String)connectivityTest.get("requestMethod")), (Matcher)CoreMatchers.equalTo((Object)REQUEST_METHOD));
        Assert.assertThat((Object)((String)connectivityTest.get("requestPath")), (Matcher)CoreMatchers.equalTo((Object)REQUEST_PATH));
        List someConnectivityTests = (List)params.get("someConnectivityTests");
        Assert.assertThat((Object)someConnectivityTests, (Matcher)Matchers.hasSize((int)3));
        someConnectivityTests.forEach(someConnectivityTest -> {
            Assert.assertThat(someConnectivityTest.keySet(), (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((Object)((String)someConnectivityTest.get("requestMethod")), (Matcher)CoreMatchers.equalTo((Object)REQUEST_METHOD));
            Assert.assertThat((Object)((String)someConnectivityTest.get("requestPath")), (Matcher)CoreMatchers.equalTo((Object)REQUEST_PATH));
        });
        List someNumbers = (List)params.get("someNumbers");
        Assert.assertThat((Object)someNumbers, (Matcher)Matchers.hasSize((int)3));
        someNumbers.forEach(someNumber -> Assert.assertThat((Object)someNumber, (Matcher)CoreMatchers.equalTo((Object)NUMBER)));
    }
}

