/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.service.oauth.internal.platform;

import org.mule.oauth.client.api.builder.ClientCredentialsLocation;

import java.nio.charset.Charset;

public class OCSSettings {

  private final String platformUrl;
  private final String tokenUrl;
  private final String clientId;
  private final String clientSecret;
  private final Charset encoding;
  private final ClientCredentialsLocation clientCredentialsLocation;
  private final String organizationId;
  private final String apiVersion;

  public OCSSettings(String platformUrl,
                     String tokenUrl,
                     String clientId,
                     String clientSecret,
                     Charset encoding,
                     ClientCredentialsLocation clientCredentialsLocation,
                     String organizationId) {
    this(platformUrl, tokenUrl, clientId, clientSecret, encoding, clientCredentialsLocation, organizationId, null);
  }

  public OCSSettings(String platformUrl,
                     String tokenUrl,
                     String clientId,
                     String clientSecret,
                     Charset encoding,
                     ClientCredentialsLocation clientCredentialsLocation,
                     String organizationId,
                     String apiVersion) {
    this.platformUrl = sanitizeUrl(platformUrl);
    this.tokenUrl = sanitizeUrl(tokenUrl);
    this.clientId = clientId;
    this.clientSecret = clientSecret;
    this.encoding = encoding;
    this.clientCredentialsLocation = clientCredentialsLocation;
    this.organizationId = organizationId;
    this.apiVersion = apiVersion;
  }

  public String getPlatformUrl() {
    return platformUrl;
  }

  public String getTokenUrl() {
    return tokenUrl;
  }

  public String getClientId() {
    return clientId;
  }

  public String getClientSecret() {
    return clientSecret;
  }

  public Charset getEncoding() {
    return encoding;
  }

  public ClientCredentialsLocation getClientCredentialsLocation() {
    return clientCredentialsLocation;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public String getApiVersion() {
    return apiVersion;
  }

  private static String sanitizeUrl(String url) {
    if (url.endsWith("/")) {
      url = url.substring(0, url.length() - 1);
    }
    return url;
  }

}
