/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.platform.DefaultPlatformManagedDancer;
import com.mulesoft.service.oauth.internal.platform.OCSClient;
import com.mulesoft.service.oauth.internal.platform.config.DefaultPlatformManagedDancerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.oauth.client.api.http.HttpClientFactory;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.internal.builder.AbstractOAuthDancerBuilder;
import org.mule.oauth.client.internal.config.AuthDancerCredentialConfig;
import org.mule.oauth.client.internal.config.TokenParserConfig;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;

public class DefaultOAuthPlatformManagedDancerBuilder
extends AbstractOAuthDancerBuilder<PlatformManagedOAuthDancer>
implements OAuthPlatformManagedDancerBuilder {
    private final List<PlatformManagedOAuthStateListener> listeners = new ArrayList<PlatformManagedOAuthStateListener>(2);
    private final OAuthService oauthService;
    private final OCSClient.OCSClientFactory ocsClientFactory;
    private String connectionUri;
    private String organizationId;
    private String platformUrl;
    private String apiVersion;

    public DefaultOAuthPlatformManagedDancerBuilder(OAuthService oauthService, OCSClient.OCSClientFactory ocsClientFactory, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClientFactory httpClientFactory, MuleExpressionLanguage expressionEvaluator) {
        super(schedulerService, lockProvider, tokensStore, httpClientFactory, expressionEvaluator);
        this.ocsClientFactory = ocsClientFactory;
        this.oauthService = oauthService;
    }

    public OAuthPlatformManagedDancerBuilder connectionUri(String connectionUri) {
        this.connectionUri = connectionUri;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder platformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public OAuthPlatformManagedDancerBuilder addListener(PlatformManagedOAuthStateListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    public PlatformManagedOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.platformUrl), (String)"platformUrl cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.connectionUri), (String)"connectionUri cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.organizationId), (String)"organizationId cannot be blank");
        DefaultPlatformManagedDancerConfig config = new DefaultPlatformManagedDancerConfig();
        config.setName(this.name);
        config.setConnectionUri(this.connectionUri);
        config.setOrganizationId(this.organizationId);
        config.setPlatformUrl(this.platformUrl);
        config.setApiVersion(this.apiVersion);
        config.setOcsClientFactory(this.ocsClientFactory);
        config.setOauthService(this.oauthService);
        config.setCredentialConfig(AuthDancerCredentialConfig.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withClientCredentialsLocation(this.clientCredentialsLocation).build());
        config.setTokenUrl(this.tokenUrl);
        config.setScopes(this.scopes);
        config.setEncoding(this.encoding);
        config.setTokenParserConfig(TokenParserConfig.builder().withResponseAccessTokenExpr(this.responseAccessTokenExpr).withResponseRefreshTokenExpr(this.responseRefreshTokenExpr).withResponseExpiresInExpr(this.responseExpiresInExpr).build());
        config.setCustomParametersExtractorsExprs(this.customParametersExtractorsExprs);
        config.setResourceOwnerIdTransformer(this.resourceOwnerIdTransformer);
        config.setSchedulerService(this.schedulerService);
        config.setLockProvider(this.lockProvider);
        config.setTokensStore(this.tokensStore);
        config.setHttpClient((HttpClient)this.httpClientFactory.get());
        config.setExpressionEvaluator(this.expressionEvaluator);
        config.setListeners(this.listeners);
        return new DefaultPlatformManagedDancer(config);
    }
}

