/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.extensions.fips;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.util.Asserts;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.tests.extensions.fips.FipsComplianceTestUtils;

public class FipsComplianceTestOperations {
    public static final String BCFIPS_PROVIDER_NAME = "BCFIPS";
    public static final String THE_PROVIDER_IS_NOT_BCFIPS_ERROR_MESSAGE = "The provider is not BCFIPS";
    public static final String THE_RSA_FACTORY_IS_NULL_ERROR_MESSAGE = "The RSA factory is null";
    public static final String RSA_KEYSTORE_FACTORY_TYPE = "RSA";
    public static final String EC_KEYSTORE_FACTORY_TYPE = "EC";
    public static final String THE_EC_PROVIDER_IS_NULL_ERROR_MESSAGE = "The EC provider is null";
    public static final String SECP_384_R_1_SPEC = "secp384r1";
    public static final String SECP_256_R_1_SPEC = "secp256r1";
    public static final String FAILED_TO_GENERATE_KEY_PAIR_ERROR_MESSAGE = "Failed to generate key pair";
    public static final String JDK_TLS_DISABLED_ALGORITHMS_PROP = "jdk.tls.disabledAlgorithms";
    public static final String DISABLE_SUITES_TEMPLATE_ERROR_MESSAGE = "Disabled cipher suite %s is not honored in %s ";
    public static final String X_509_CERTIFICATE_FACTORY = "X.509";
    public static final String THE_FACTORY_IS_NULL_ERROR_MESSAGE = "The factory is null";
    public static final String PROVIDER_ERROR_TEMPLATE_MESSAGE = "The provider is not SUN for the x509 certificate. It is %s";
    public static final String DEFAULT_ALGORITH = "DEFAULT";
    public static final String NONCEANDIV_ALGORITHM = "NONCEANDIV";
    public static final String EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE = "Expected to generate symmetric key";
    public static final String AES_CIPHER_ALGORITH = "AES/GCM/NoPadding";
    public static final String AES_ALGORITH_KEY_GENERATOR_NAME = "AES";
    public static final String SHA_384 = "SHA-384";
    public static final String SHA_512 = "SHA-512";
    public static final String SHA_3_256 = "SHA3-256";
    public static final String SHA_3_384 = "SHA3-384";
    public static final String SHA_3_512 = "SHA3-512";
    public static final String SHA_256 = "SHA-256";
    public static final String RSA_NONE_OAEPWITH_SHA_1_AND_MGF_1_PADDING = "RSA/NONE/OAEPwithSHA1andMGF1Padding";
    public static final String RSA_NONE_OAEPWITH_SHA_256_AND_MGF_1_PADDING = "RSA/NONE/OAEPwithSHA256andMGF1Padding";
    public static final String TESTING_KEY_WRAP_MODE_FOR_CIPHER_ERROR_MESSAGE = "Testing key wrap mode for cipher ";

    @MediaType(value="*/*", strict=false)
    public String testKeyGenerator(String alg, int keySize) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(alg);
        kg.init(keySize);
        SecretKey key = kg.generateKey();
        Asserts.check((key != null && key.getEncoded().length == keySize / 8 ? 1 : 0) != 0, (String)EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE);
        Asserts.check((boolean)kg.getProvider().getName().equals(BCFIPS_PROVIDER_NAME), (String)("Expected fips provider but was " + kg.getProvider()));
        kg.init(keySize, new SecureRandom());
        key = kg.generateKey();
        Asserts.check((key != null && key.getEncoded().length == keySize / 8 ? 1 : 0) != 0, (String)EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE);
        kg.init(keySize, SecureRandom.getInstance(DEFAULT_ALGORITH));
        key = kg.generateKey();
        Asserts.check((key != null && key.getEncoded().length == keySize / 8 ? 1 : 0) != 0, (String)EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE);
        kg.init(keySize, SecureRandom.getInstance(NONCEANDIV_ALGORITHM));
        key = kg.generateKey();
        Asserts.check((key != null && key.getEncoded().length == keySize / 8 ? 1 : 0) != 0, (String)EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE);
        kg.init(keySize, SecureRandom.getInstance(DEFAULT_ALGORITH));
        key = kg.generateKey();
        Asserts.check((key != null && key.getEncoded().length == keySize / 8 ? 1 : 0) != 0, (String)EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE);
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testProviderKeyGenerator(String algorithm, String provider) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(algorithm, provider);
        kg.init(128, new SecureRandom());
        SecretKey key = kg.generateKey();
        Asserts.check((key != null && key.getEncoded().length == 16 ? 1 : 0) != 0, (String)EXPECTED_TO_GENERATE_SYMMETRIC_KEY_ERROR_MESSAGE);
        Asserts.check((boolean)Objects.equals(kg.getProvider().getName(), BCFIPS_PROVIDER_NAME), (String)("Expected fips provider but was " + kg.getProvider()));
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testAES() throws Exception {
        Cipher cipher = Cipher.getInstance(AES_CIPHER_ALGORITH);
        FipsComplianceTestUtils.assertFipsProvider(cipher.getProvider());
        KeyGenerator keyGen = KeyGenerator.getInstance(AES_ALGORITH_KEY_GENERATOR_NAME);
        keyGen.init(256);
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[16];
        random.nextBytes(nonce);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(96, nonce);
        cipher.init(1, (Key)keyGen.generateKey(), gcmSpec);
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testCertificateFactory() throws Exception {
        CertificateFactory factory = CertificateFactory.getInstance(X_509_CERTIFICATE_FACTORY);
        Asserts.check((factory != null ? 1 : 0) != 0, (String)THE_FACTORY_IS_NULL_ERROR_MESSAGE);
        Asserts.check((boolean)BCFIPS_PROVIDER_NAME.equals(factory.getProvider().getName()), (String)String.format(PROVIDER_ERROR_TEMPLATE_MESSAGE, factory.getProvider().getName()));
        return "All tests passed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MediaType(value="*/*", strict=false)
    public String testCipherSuiteDisabled() throws Exception {
        String[] tlsDisabledAlgorithms = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_GCM_SHA384"};
        String previousDisabledAlgorithms = System.getProperty(JDK_TLS_DISABLED_ALGORITHMS_PROP);
        try {
            Security.setProperty(JDK_TLS_DISABLED_ALGORITHMS_PROP, "SSLv3, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL, MD5, DSA, RSA keySize < 2048, DES40_CBC, RC4_40, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384, TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384, TLS_RSA_WITH_AES_256_GCM_SHA384");
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            Asserts.check((ctx != null ? 1 : 0) != 0, (String)"Expected to load SSL Context in FIPS mode");
            ctx.init(new KeyManager[0], new TrustManager[0], new SecureRandom());
            ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(new KeyManager[0], new TrustManager[0], null);
            SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket();
            HashSet set = new HashSet();
            Collections.addAll(set, socket.getEnabledCipherSuites());
            for (String cipherSuite : tlsDisabledAlgorithms) {
                if (!set.contains(cipherSuite)) continue;
                throw new IllegalStateException(String.format(DISABLE_SUITES_TEMPLATE_ERROR_MESSAGE, cipherSuite, set));
            }
            String string = "All tests passed";
            return string;
        }
        finally {
            if (previousDisabledAlgorithms != null) {
                Security.setProperty(JDK_TLS_DISABLED_ALGORITHMS_PROP, previousDisabledAlgorithms);
            } else {
                Security.setProperty(JDK_TLS_DISABLED_ALGORITHMS_PROP, "");
            }
        }
    }

    @MediaType(value="*/*", strict=false)
    public String testEc() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(EC_KEYSTORE_FACTORY_TYPE);
        kpg.initialize(new ECGenParameterSpec(SECP_384_R_1_SPEC), SecureRandom.getInstance(DEFAULT_ALGORITH));
        Asserts.check((kpg.generateKeyPair() != null ? 1 : 0) != 0, (String)FAILED_TO_GENERATE_KEY_PAIR_ERROR_MESSAGE);
        kpg.initialize(new ECGenParameterSpec(SECP_384_R_1_SPEC));
        Asserts.check((kpg.generateKeyPair() != null ? 1 : 0) != 0, (String)FAILED_TO_GENERATE_KEY_PAIR_ERROR_MESSAGE);
        kpg.initialize(new ECGenParameterSpec(SECP_256_R_1_SPEC), new SecureRandom());
        Asserts.check((kpg.generateKeyPair() != null ? 1 : 0) != 0, (String)FAILED_TO_GENERATE_KEY_PAIR_ERROR_MESSAGE);
        FipsComplianceTestUtils.assertFipsProvider(kpg.getProvider());
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testRsaKeyFactory() throws Exception {
        KeyFactory factory = KeyFactory.getInstance(RSA_KEYSTORE_FACTORY_TYPE);
        Asserts.check((factory != null ? 1 : 0) != 0, (String)THE_RSA_FACTORY_IS_NULL_ERROR_MESSAGE);
        Asserts.check((boolean)BCFIPS_PROVIDER_NAME.equals(factory.getProvider().getName()), (String)THE_PROVIDER_IS_NOT_BCFIPS_ERROR_MESSAGE);
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testEcKeyFactory() throws Exception {
        KeyFactory factory = KeyFactory.getInstance(EC_KEYSTORE_FACTORY_TYPE);
        Asserts.check((factory != null ? 1 : 0) != 0, (String)THE_EC_PROVIDER_IS_NULL_ERROR_MESSAGE);
        Asserts.check((boolean)BCFIPS_PROVIDER_NAME.equals(factory.getProvider().getName()), (String)THE_PROVIDER_IS_NOT_BCFIPS_ERROR_MESSAGE);
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testKeyStore() throws Exception {
        KeyStore store = KeyStore.getInstance("BCFKS");
        FipsComplianceTestUtils.assertFipsProvider(store.getProvider());
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[32];
        random.nextBytes(data);
        char[] generated = Base64.getEncoder().encodeToString(data).toCharArray();
        KeyGenerator kg = KeyGenerator.getInstance(AES_ALGORITH_KEY_GENERATOR_NAME);
        kg.init(256);
        SecretKey key = kg.generateKey();
        store.load(null, null);
        store.setEntry("somealias", new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection(generated));
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        store.store(out, generated);
        store = KeyStore.getInstance("BCFKS");
        store.load(new ByteArrayInputStream(out.toByteArray()), generated);
        FipsComplianceTestUtils.assertFipsProvider(store.getProvider());
        Asserts.check((boolean)Arrays.equals(key.getEncoded(), store.getKey("somealias", generated).getEncoded()), (String)"Keys are not the same between save and read");
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testMac() throws Exception {
        Mac mac = Mac.getInstance("HMACSHA256");
        FipsComplianceTestUtils.assertFipsProvider(mac.getProvider());
        mac = Mac.getInstance("HMACSHA384");
        FipsComplianceTestUtils.assertFipsProvider(mac.getProvider());
        mac = Mac.getInstance("HMACSHA512");
        FipsComplianceTestUtils.assertFipsProvider(mac.getProvider());
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testMessageDigest() throws Exception {
        MessageDigest md = MessageDigest.getInstance(SHA_256);
        FipsComplianceTestUtils.assertFipsProvider(md.getProvider());
        md = MessageDigest.getInstance(SHA_384);
        FipsComplianceTestUtils.assertFipsProvider(md.getProvider());
        md = MessageDigest.getInstance(SHA_512);
        FipsComplianceTestUtils.assertFipsProvider(md.getProvider());
        md = MessageDigest.getInstance(SHA_3_256);
        FipsComplianceTestUtils.assertFipsProvider(md.getProvider());
        md = MessageDigest.getInstance(SHA_3_384);
        FipsComplianceTestUtils.assertFipsProvider(md.getProvider());
        md = MessageDigest.getInstance(SHA_3_512);
        FipsComplianceTestUtils.assertFipsProvider(md.getProvider());
        return "All tests passed";
    }

    @MediaType(value="*/*", strict=false)
    public String testPasswordInput() throws Exception {
        try {
            KeyStore store = KeyStore.getInstance("PKI-PLAIN");
            store.load(null, "blah".toCharArray());
        }
        catch (IllegalArgumentException e) {
            return "All tests passed";
        }
        throw new RuntimeException("Invalid password input should fail");
    }

    @MediaType(value="*/*", strict=false)
    public String testRSA() throws Exception {
        block3: {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(RSA_KEYSTORE_FACTORY_TYPE);
            kpg.initialize(2048, SecureRandom.getInstance(DEFAULT_ALGORITH));
            Asserts.check((kpg.generateKeyPair() != null ? 1 : 0) != 0, (String)FAILED_TO_GENERATE_KEY_PAIR_ERROR_MESSAGE);
            FipsComplianceTestUtils.assertFipsProvider(kpg.getProvider());
            kpg.initialize(2048);
            KeyPair pair = kpg.generateKeyPair();
            Asserts.check((pair != null ? 1 : 0) != 0, (String)FAILED_TO_GENERATE_KEY_PAIR_ERROR_MESSAGE);
            SecureRandom random = new SecureRandom();
            byte[] key = new byte[16];
            random.nextBytes(key);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(pair.getPrivate());
            signature.update(key);
            signature.sign();
            for (String s : new String[]{RSA_NONE_OAEPWITH_SHA_1_AND_MGF_1_PADDING, RSA_NONE_OAEPWITH_SHA_256_AND_MGF_1_PADDING}) {
                Cipher cipher = Cipher.getInstance(s);
                cipher.init(3, pair.getPublic());
                cipher.wrap(new SecretKeySpec(key, AES_ALGORITH_KEY_GENERATOR_NAME));
            }
            try {
                kpg.initialize(512);
                kpg.generateKeyPair();
            }
            catch (Error e) {
                if (e.getMessage().contains("unapproved")) break block3;
                throw new IllegalStateException(e);
            }
        }
        return "All tests passed";
    }
}

