/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.functional;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.functional.AbstractXmlExtensionMuleArtifactFunctionalTestCase;

import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;

public class ModuleWithCoreEeTestCase extends AbstractXmlExtensionMuleArtifactFunctionalTestCase {

  @Override
  protected String[] getModulePaths() {
    return new String[] {"modules/module-using-core-ee.xml"};
  }

  @Override
  protected String getConfigFile() {
    return "flows/flows-using-smart-connector-using-core-ee.xml";
  }

  @Override
  protected boolean shouldValidateXml() {
    return false;
  }

  @Test
  public void testFlowUsingCoreEeSetMessageThroughDw() throws Exception {
    String payloadAsString = "Wubba Lubba Dub Dub";
    String attributesAsString = "someAttribute";

    assertFlow("flowUsingCoreEeSetMessageThroughDw", payloadAsString, attributesAsString);
  }

  private void assertFlow(String flowName, String payloadAsString, String attributesAsString) throws Exception {
    CoreEvent muleEvent = flowRunner(flowName).keepStreamsOpen().run();

    // payload
    assertThat(getPayloadAsString(muleEvent.getMessage()), is(payloadAsString));

    TransformationService transformationService = muleContext.getTransformationService();

    // attributes
    TypedValue<Object> attributes = muleEvent.getMessage().getAttributes();
    assertThat(transformationService.transform(attributes.getValue(), attributes.getDataType(), DataType.STRING),
               equalTo(attributesAsString));

    // variables should not be propagated
    assertThat(muleEvent.getVariables().entrySet(), IsCollectionWithSize.hasSize(0));
  }
}
