/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.extension.dsl;

import com.mulesoft.mule.test.extension.dsl.AbstractElementModelTestCase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.metadata.api.dsl.DslElementModel;

public class DeclarationBasedElementModelFactoryTestCase
extends AbstractElementModelTestCase {
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.appXml.updateExpectedFilesOnError");
    private final String configFile = "ee-app-declaration.xml";
    private String expectedAppXml;

    protected String getConfigFile() {
        return "ee-app-declaration.xml";
    }

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("ee-app-declaration.xml"));
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Test
    public void serialize() throws Exception {
        String serializationResult = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(this.createAppDeclarationWithTransform());
        try {
            DeclarationBasedElementModelFactoryTestCase.compareXML(this.expectedAppXml, serializationResult);
        }
        catch (Throwable t) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                File root = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("ee-app-declaration.xml").toURI()).getParentFile().getParentFile().getParentFile();
                File testDir = new File(root, "src/test/resources");
                File target = new File(testDir, "ee-app-declaration.xml");
                Files.writeString(target.toPath(), (CharSequence)serializationResult, new OpenOption[0]);
                System.out.println(this.expectedAppXml + " fixed");
            }
            throw t;
        }
    }

    @Test
    public void resolveTransformToElemenModel() {
        OperationElementDeclaration transform = (OperationElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)ElementDeclarer.forExtension((String)"ee").newOperation("transform").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("setPayload", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("script", "<![CDATA[%output application/java\n                    ---\n                    payload\n                    ]]>").build()).withParameter("setAttributes", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("script", ParameterSimpleValue.cdata((String)"attributes")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Set Variables").withParameter("variables", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("foo", "<![CDATA[fooVarValue]]>").withParameter("bar", ParameterSimpleValue.cdata((String)"%output application/java\n                    ---\n                    null\n")).withParameter("zap", "zapResource").build()).build()).getDeclaration())).getDeclaration();
        DslElementModel transformElement = this.resolve((ElementDeclaration)transform);
        this.assertHasParameterGroup((ParameterizedModel)transformElement.getModel(), "Message");
        this.assertHasParameterGroup((ParameterizedModel)transformElement.getModel(), "Set Variables");
        MatcherAssert.assertThat((Object)transformElement.getConfiguration().isPresent(), (Matcher)Matchers.is((Object)true));
        this.assertElementName(transformElement, "transform");
        MatcherAssert.assertThat((Object)transformElement.getContainedElements(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)transformElement.findElement("setPayload").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)transformElement.findElement("setAttributes").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)transformElement.findElement("variables").isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

