/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.test.extension.dsl.ee;

import static java.lang.Thread.currentThread;
import static org.mule.runtime.core.api.util.IOUtils.getResourceAsString;
import static org.mule.test.module.extension.internal.util.ExtensionsTestUtils.compareXML;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;

import java.io.IOException;
import java.io.InputStream;

import org.junit.Before;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class ArtifactDeclarationSerializerTestCase extends AbstractElementModelTestCase {

  private String configFile = "ee-app-declaration.xml";

  private String expectedAppXml;
  private ArtifactDeclaration applicationDeclaration;
  private String expectedAppJson;

  @Before
  public void loadExpectedResult() throws IOException {
    expectedAppXml = getResourceAsString(configFile, getClass());
    applicationDeclaration = createAppDeclarationWithTransform();
    expectedAppJson = getResourceAsString("ee-app-declaration.json", getClass());
  }

  @Override
  protected String[] getConfigFiles() {
    return new String[] {configFile};
  }

  @Test
  public void serialize() throws Exception {
    String serializationResult = ArtifactDeclarationXmlSerializer.getDefault(dslContext).serialize(applicationDeclaration);
    compareXML(expectedAppXml, serializationResult);
  }

  @Test
  public void loadAndSerialize() throws Exception {
    InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFile);
    ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault(dslContext);

    ArtifactDeclaration artifact = serializer.deserialize(configFile, configIs);
    String serializationResult = serializer.serialize(artifact);
    compareXML(expectedAppXml, serializationResult);
  }

  @Test
  public void serializesToJson() {
    InputStream configIs = currentThread().getContextClassLoader().getResourceAsStream(configFile);
    ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault(dslContext);
    ArtifactDeclaration expectedDeclaration = serializer.deserialize(configIs);

    ArtifactDeclarationJsonSerializer jsonSerializer = ArtifactDeclarationJsonSerializer.getDefault(true);
    String actualAppJson = jsonSerializer.serialize(expectedDeclaration);

    JSONAssert.assertEquals(expectedAppJson, actualAppJson, true);
  }

}
